$(document).ready(function () {
    $('body').attr('translate', 'no');

    document.addEventListener("dragover", function (event) {
        event.preventDefault();
    });

    // Impedir que o evento "drop" seja tratado na página
    document.addEventListener("drop", function (event) {
        event.preventDefault();
    });

    const verificaParametroRepresentanteUsuario = () => {
        const parametrosLogin = sessionStorage.getItem('web@parametros') ?? [];
        if (parametrosLogin.length > 0) {
            const parametrosObject = JSON.parse(parametrosLogin);
            const valor = (parametrosObject.filter(param => param.TIPO == 'SISTEMA' && param.POSICAO == '2')[0])?.VALOR;
            return valor == '1';
        }
    }

    // $('.switcher-icon').off('click');
    // $(".switcher-icon").on("click", function (e) {
    //     e.preventDefault();
    //     $(".right-sidebar").addClass("right-toggled");
    // });
    $(".switcher-icon").off("click");
    $(".switcher-icon").click(function (e) {
        // $(".right-sidebar").addClass("right-toggled")

        if ($(".right-sidebar").hasClass("right-toggled")) {
            $(".right-sidebar").removeClass("right-toggled");
        } else {
            $(".right-sidebar").addClass("right-toggled")
        }
    });




    var viewportmeta = document.querySelector('meta[name="viewport"]');
    viewportmeta.content = 'user-scalable=NO, width=device-width, initial-scale=1.0'
    /* todo input com a classe focus irá saltar para o proximo campo disponível ou voltar ao primeiro
     */
    $(".focus").bind("keypress", function (e) {
        if (e.keyCode == 13) {
            var inps = $(".focus:not('.d-none')"); //$("input, select, textarea"); //add select too
            for (var x = 0; x < inps.length; x++) {
                if (inps[x] == this) {
                    while ((inps[x + 1] !== undefined) && ((inps[x]).id == (inps[x + 1]).id)) {
                        x++;
                    }
                    if ((x + 1) < inps.length) {
                        $(inps[x + 1]).focus();
                    } else { $(inps[0]).focus(); }
                }
            }
            e.preventDefault();
        }
    });
    /* funcao que executa uma tarefa com delay 
     */
    jQuery.fn.extend({
        delayKeyup: function (callback, ms) {
            var t = this;
            var timer = 0;
            $(t).keyup(function () {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            });
            return $(t);
        }
    });


    var traducoesDataTable = {
        P: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: "0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            language: {
                decimal: ",",
                thousands: ".",
            },
            oPaginate: {
                sNext: "Próximo",
                sPrevious: "Anterior",
                sFirst: "Primeiro",
                sLast: "Último",
            },
            oAria: {
                sSortAscending: ": Ordenar colunas de forma ascendente",
                sSortDescending: ": Ordenar colunas de forma descendente",
            },
        },
        E: {
            sEmptyTable: "No se encontraron registros",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: "0 registros",
            sInfoFiltered: "(filtrado de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "Mostrar _MENU_ resultados",
            sLoadingRecords: "Cargando...",
            sProcessing: "Procesando...",
            sZeroRecords: "No se encontraron registros",
            sSearch: "Buscar",
            language: {
                decimal: ",",
                thousands: ".",
            },
            oPaginate: {
                sNext: "Siguiente",
                sPrevious: "Anterior",
                sFirst: "Primero",
                sLast: "Último",
            },
            oAria: {
                sSortAscending: ": Ordenar columnas de forma ascendente",
                sSortDescending: ": Ordenar columnas de forma descendente",
            },
        },
        I: {
            sEmptyTable: "No data available in table",
            sInfo: "Showing _TOTAL_ entries",
            sInfoEmpty: "Showing 0 entries",
            sInfoFiltered: "(filtered from _MAX_ total entries)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "Show _MENU_ entries",
            sLoadingRecords: "Loading...",
            sProcessing: "Processing...",
            sZeroRecords: "No matching records found",
            sSearch: "Search:",
            language: {
                decimal: ",",
                thousands: ".",
            },
            oPaginate: {
                sNext: "Next",
                sPrevious: "Previous",
                sFirst: "First",
                sLast: "Last",
            },
            oAria: {
                sSortAscending: ": activate to sort column ascending",
                sSortDescending: ": activate to sort column descending",
            },
        },
        M: {
            sEmptyTable: "没有找到记录",
            sInfo: "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
            sInfoEmpty: "显示第 0 至 0 项结果，共 0 项",
            sInfoFiltered: "(从 _MAX_ 条记录中过滤)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "显示 _MENU_ 项结果",
            sLoadingRecords: "加载中...",
            sProcessing: "处理中...",
            sZeroRecords: "没有找到匹配的记录",
            sSearch: "搜索:",
            language: {
                decimal: ",",
                thousands: ".",
            },
            oPaginate: {
                sNext: "下一页",
                sPrevious: "上一页",
                sFirst: "首页",
                sLast: "末页",
            },
            oAria: {
                sSortAscending: ": 升序排列",
                sSortDescending: ": 降序排列",
            },
        },
    };

    $.fn.dataTable.defaults.language = traducoesDataTable[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P'];
    $.fn.dataTable.defaults.initComplete = async function () { await traduzirElementosDataTable(this.api()) };

    (async function () {
        if (typeof Driver === 'undefined') return;
        const originalStart = Driver.prototype.start;

        Driver.prototype.start = async function () {
            const driver = this;

            if (!driver) return;

            if (driver.steps && Array.isArray(driver.steps)) {
                for (let step of driver.steps) {
                    if (step.popover?.options) {
                        const keys = [
                            "title",
                            "description",
                            "doneBtnText",
                            "closeBtnText",
                            "nextBtnText",
                            "prevBtnText",
                        ];

                        for (const k of keys) {
                            if (step.popover.options[k]) {
                                step.popover.options[k] = await traduzSentenca(step.popover.options[k]);
                            }
                        }
                    }
                }
            }

            originalStart.call(driver);
        };
    })();

    (async function () {
        if (typeof $.fn.validate === 'undefined') return;

        const originalValidate = $.fn.validate;

        $.fn.validate = function (options) {
            const form = this;

            const validator = originalValidate.call(form, options);

            const messages = validator.settings && validator.settings.messages ? validator.settings.messages : {};

            for (let field in messages) {
                if (messages.hasOwnProperty(field)) {
                    if (typeof messages[field].required === 'string') {
                        traduzSentencaComPromise(messages[field].required).then(traducao => {
                            messages[field].required = traducao;
                        });
                    }
                }
            }

            if (validator.settings) {
                validator.settings.messages = messages;
            }

            return validator;
        };
    })();


    jQuery.fn.extend({
        pesquisa_array: async function (arr_txtCod, arr_pk_field, arr_desc_field, data_url, caption, tabela, callback, bSimples, serverSide) {
            let empresa = getCookie('empresa');
            let usuario = getCookie('usuario').toUpperCase();
            var t = this;

            data_url = JSON.parse(data_url.substr(34, data_url.length).trim())
            tabela = tabela.toUpperCase();
            if (['REGIAO', 'REPRESEN'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = tabela == 'REGIAO' ? 'REGIAO' : 'CODREP';
                const temRegistroNaEmpValor = await fazSelectNaEmpValor('', tabela);
                if (temRegistroNaEmpValor.length > 0) {
                    data_url = {
                        ...data_url,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                        }]
                    }
                }
            }
            if (tabela == 'ENTIDADE') {

                const apenasClientesVinculadosAoRepresentante = (await verificaParametroRepresentanteUsuario()) && (retornaRepresentanteUsuario() != '');
                const isMaster = await uMasterOuSupervisor();
                if ((apenasClientesVinculadosAoRepresentante) && (!isMaster)) {
                    if (!data_url.where) {
                        data_url.where = [];
                    }
                    data_url = {
                        ...data_url,
                        where: [...data_url.where, `CODREP ='${retornaRepresentanteUsuario()}'`]
                    }
                }
            }
            data_url = '/sisplan/funcoes/v1/pesquisa?JSON=' + JSON.stringify(data_url);


            $(t).unbind('pesquisou');
            $(t).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            // habilita abrir a pesquisa com a tecla F4
            $(arr_txtCod[0]).keyup(function (e) {
                if (e.keyCode == 115) {
                    $(t).click();
                    e.preventDefault();
                    e.stopPropagation();
                }
            });

            $(t).unbind('click');
            $(t).click(async function () {
                if (serverSide == undefined) {
                    var dataSet = [];
                    var dataSetCols = [];
                    var _url = "";
                    // a url pode ser uma string ou uma function
                    if (typeof (data_url) === "function") {
                        _url = data_url();
                    } else {
                        _url = data_url;
                    }
                    _url += _url != '' ? `&empresa=${empresa}&usuario=${usuario}` : `empresa=${empresa}&usuario=${usuario}`;
                    // abre a tela da pesquisa
                    $("#pesquisaModalLabel").text(await traduzSentenca('Pesquisa de ') + await traduzSentenca(caption.toLowerCase().replace('pesquisa de ', '').replace('pesquisa ', '')));
                    $("#pesquisaModal").modal("show");
                    $('#txtTabelaPesquisa').val(tabela);
                    validaBotaoRedirecionar();
                    $.LoadingOverlay("show");

                    var response;
                    try {
                        response = await requisicao('GET', '', _url, '', 10000);
                    } catch (error) {
                        $.LoadingOverlay("hide");
                        msgErro('Erro (' + error + ').');
                        $("#pesquisaModal").modal("hide");
                        return;
                    }

                    try {
                        if (response.status != 200) {
                            $.LoadingOverlay("hide");
                            msgErro(jsonStr['RESULT'][0].mensagem)
                            return
                        }

                        var result = await response.json();

                        $.LoadingOverlay("hide");
                        if (result['RESULT'][0]) {
                            if (!result['RESULT'][0].length) {
                                dataSet.push(result['RESULT']);
                            } else {
                                dataSet = result['RESULT'][0];
                            }

                            if (!$.isEmptyObject(dataSet[0])) {
                                // preciso dinamicamente ter a relação com o nome das colunas para tabela
                                const keys = Object.keys(dataSet[0]);
                                // for (let k in keys) {
                                //     if (['NUMERO', 'CODCLI', 'PED_CLI', 'CODIGO'].indexOf(keys[k].toUpperCase()) >= 0) {
                                //         dataSetCols.push({ 'title': keys[k], 'data': keys[k], 'width': '80px' });
                                //     } else {
                                //         dataSetCols.push({ 'title': keys[k], 'data': keys[k] });
                                //     }
                                // }
                                keys.forEach((item) => {
                                    if (['NUMERO', 'CODCLI', 'PED_CLI', 'CODIGO'].indexOf(item.toUpperCase()) >= 0) {
                                        dataSetCols.push({ 'title': item, 'data': item, 'width': '80px' });
                                    } else {
                                        dataSetCols.push({ 'title': item, 'data': item });
                                    }
                                })

                                $("#pesquisaModalBody").html('<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="pesquisaModalTable" ></table>');
                                //cria a tabela usando os dados e colunas
                                var table = $('#pesquisaModalTable').dataTable({
                                    destroy: true,
                                    keys: true,
                                    autoWidth: true,
                                    order: [],
                                    "data": dataSet,
                                    "columns": dataSetCols,
                                });

                                $("body").keydown(function (e) {
                                    const qtdeLinhas = $("#pesquisaModalTable tbody tr").length;
                                    if (e.which === 80 && e.altKey) {
                                        e.preventDefault();
                                        $("input[type='search']").focus();
                                    }
                                    if (e.which === 13 && qtdeLinhas === 1) {
                                        $("#pesquisaModalTable tbody tr td")[0].click();
                                        table.$('tr.selected').removeClass('selected');
                                    }
                                });

                                // desenha a seleção do registro clicaco
                                $('#pesquisaModalTable tbody').on('click', 'tr', function () {
                                    if ($(this).hasClass('selected')) {
                                        $(this).removeClass('selected');
                                    } else {
                                        table.$('tr.selected').removeClass('selected');
                                        $(this).addClass('selected');
                                    }
                                });
                                // duplo click faz escolher o registro e fechar a pesquisa
                                $('#pesquisaModalTable tbody').on('dblclick', 'tr', function (e) {
                                    e.preventDefault();
                                    document.firstElementChild.style.zoom = "reset";
                                    table.$('tr.selected').removeClass('selected');
                                    $(this).addClass('selected');
                                    $("#pesquisaModalSelecionar").click();
                                });
                                // botão selecionar
                                $("#pesquisaModalSelecionar").unbind('click');
                                $("#pesquisaModalSelecionar").click(function () {
                                    var data = table.api().row('.selected').data();
                                    for (var i in arr_pk_field) {
                                        if (data && data[arr_pk_field[i]].toString() && data[arr_desc_field[i]].toString()) {
                                            if ((bSimples != undefined) && (bSimples[i] != '') && (bSimples[i] != undefined)) {
                                                $(arr_txtCod[i]).val(data[arr_pk_field[i]].toString());
                                            } else {
                                                $(arr_txtCod[i]).val('[' + data[arr_pk_field[i]].toString() + '] - ' + data[arr_desc_field[i]]);
                                            }
                                            $(arr_txtCod[i]).attr('data-selecionado', true);
                                            $(arr_txtCod[i]).attr('data-chave', data[arr_pk_field[i]]);
                                            $(arr_txtCod[i]).attr('data-desc', data[arr_desc_field[i]]);
                                            $("#pesquisaModal").modal("hide");
                                        } else {
                                            // $(arr_txtCod[i]).attr('data-selecionado', false);
                                            // $(arr_txtCod[i]).val('');
                                        }
                                    }
                                    $(t).trigger('pesquisou');
                                    // if (data && data[pk_field].toString() && data[desc_field]) {
                                    //     $(txtCod).val('[' + data[pk_field].toString() + '] - ' + data[desc_field]);
                                    //     $("#pesquisaModal").modal("hide");
                                    // }
                                });
                                // KeyTable ajuda a navegar na tabela com as teclas~
                                try {
                                    var keytable = new $.fn.dataTable.KeyTable(table);
                                    // se precionar enter executa duplo click
                                    keytable.event.action(null, null, function (node) {
                                        $(node).dblclick();
                                    });
                                } catch (error) {

                                }
                                // posiciona a navegacao via teclas no primeiro registro
                                if (dataSet.length >= 1) {
                                    $("#pesquisaModalTable tbody tr td")[0].click();
                                    table.$('tr.selected').removeClass('selected');
                                }
                            }
                        } else {
                            msgErro('Erro ao consultar dados, verifique a conexão.');
                            $("#pesquisaModal").modal("hide");
                        }
                    } catch (error) {
                        console.log(error)
                        $.LoadingOverlay("hide");
                        msgErro('Erro ao consultar dados, verifique a conexão.');
                        $("#pesquisaModal").modal("hide");
                    }

                    // limpa evento
                    //$("#pesquisaModalSelecionar").unbind('click');
                    // seta o titulo da pesquisa
                    $("#pesquisaModalSelecionar").show();
                    $("#pesquisaModalConfirmar").hide();
                    // evento que controla quando a pesquisa fecha
                    $("#pesquisaModal").unbind('hidden.bs.modal');
                    $('#pesquisaModal').on('hidden.bs.modal', function (_) {
                        $('#pesquisaModalBody').empty();
                        $(arr_txtCod[0]).focus();
                    });
                } else {
                    // abre a tela da pesquisa
                    $("#pesquisaModalLabel").text(await traduzSentenca('Pesquisa de ') + await traduzSentenca(caption.toLowerCase().replace('pesquisa de ', '').replace('pesquisa ', '')));
                    $("#pesquisaModal").modal("show");
                    $.LoadingOverlay("show");
                    let camposTabela = '';
                    for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                        camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelect[i]}</th>`
                    };
                    try {
                        const protocolo = getCookie('protocolo');
                        $("#pesquisaModalBody").html(`<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="pesquisaModalTable" ><thead><tr>${camposTabela}</tr></thead><tbody></tbody></table>`);
                        //cria a tabela usando os dados e colunas
                        var table = $('#pesquisaModalTable').DataTable({
                            destroy: true,
                            lengthChange: false,
                            autoWidth: true,
                            serverSide: true,
                            processing: false,
                            ajax: {
                                url: `${protocolo}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                                type: "GET",
                                headers: { 'Authorization': BASIC_AUTH },
                                data: {
                                    "EMPRESA": getCookie('empresa'),
                                    "JSON": data_url,
                                    "TIPO_PESQUISA": $('#selectPesquisa').val() ?? ''
                                }
                            },
                        });

                        // desenha a seleção do registro clicaco
                        $('#pesquisaModalTable tbody').on('click', 'tr', function () {
                            if ($(this).hasClass('selected')) {
                                $(this).removeClass('selected');
                            } else {
                                $('#pesquisaModalTable').DataTable().$('tr.selected').removeClass('selected');
                                $(this).addClass('selected');
                            }
                        });
                        // duplo click faz escolher o registro e fechar a pesquisa
                        $('#pesquisaModalTable tbody').on('dblclick', 'tr', function (e) {
                            e.preventDefault();
                            document.firstElementChild.style.zoom = "reset";
                            table.$('tr.selected').removeClass('selected');
                            $(this).addClass('selected');
                            $("#pesquisaModalSelecionar").click();
                        });
                        // botão selecionar
                        $("#pesquisaModalSelecionar").unbind('click');
                        $("#pesquisaModalSelecionar").click(function () {
                            var data = table.row('.selected').data();
                            var dataAux = data;
                            data = {};
                            for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                                data[JSON.parse(data_url).camposSelect[i]] = dataAux[i]
                            };
                            for (var i in arr_pk_field) {
                                if (data && data[arr_pk_field[i]].toString() && data[arr_desc_field[i]].toString()) {
                                    if ((bSimples != undefined) && (bSimples[i] != '') && (bSimples[i] != undefined)) {
                                        $(arr_txtCod[i]).val(data[arr_pk_field[i]].toString());
                                    } else {
                                        $(arr_txtCod[i]).val('[' + data[arr_pk_field[i]].toString() + '] - ' + data[arr_desc_field[i]]);
                                    }
                                    $(arr_txtCod[i]).attr('data-selecionado', true);
                                    $(arr_txtCod[i]).attr('data-chave', data[arr_pk_field[i]]);
                                    $(arr_txtCod[i]).attr('data-desc', data[arr_desc_field[i]]);
                                    $("#pesquisaModal").modal("hide");
                                }
                            }
                            $(t).trigger('pesquisou');
                        });

                    } catch (error) {
                        console.log(error)
                        $.LoadingOverlay("hide");
                        msgErro('Erro ao consultar dados, verifique a conexão.');
                        $("#pesquisaModal").modal("hide");
                    }

                    $.LoadingOverlay("hide");
                    $("#pesquisaModalSelecionar").show();
                    $("#pesquisaModalConfirmar").hide();
                    // evento que controla quando a pesquisa fecha
                    $("#pesquisaModal").unbind('hidden.bs.modal');
                    $('#pesquisaModal').on('hidden.bs.modal', function (_) {
                        $('#pesquisaModalBody').empty();
                        $(arr_txtCod[0]).focus();
                    });
                }
            });
        }
    });

    jQuery.fn.extend({
        pesquisa: async function (txtCod, pk_field, desc_field, data_url, caption, tabela, simples, callback, empresa = '', empIds = []) {
            // let empresa = getCookie('empresa');
            // let usuario = getCookie('usuario').toUpperCase();

            data_url = JSON.parse(data_url.substr(34, data_url.length).trim())
            tabela = tabela.toUpperCase();
            var t = this;
            // habilita abrir a pesquisa com a tecla F4
            $(txtCod).keyup(function (e) {
                if (e.keyCode == 115) {
                    $(t).click();
                    e.preventDefault();
                    e.stopPropagation();
                }
            });
            if (['REGIAO', 'REPRESEN'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = tabela == 'REGIAO' ? 'REGIAO' : 'CODREP';
                const temRegistroNaEmpValor = await fazSelectNaEmpValor('', tabela);
                if (temRegistroNaEmpValor.length > 0) {
                    if (empIds.length > 0) {
                        //CRIADO PARAMETRO EMPIDS PARA CASO SEJA NECESSÁRIO FAZER UM IN EM ALGUM SELECT DE PESQUISA QUE FAÇA PESQUISA NA TABELA REGIAO OU REPRESEN POIS CONSIDERA A EMP_VALOR
                        //TEM QUE PASSAR UM DISTINCT LA AONDE VAIS CHAMAR O AUTOCOMPLETA NO CAMPOS SELECT EX: "camposSelect":[ "distinct codrep", "nome"]}` -- BRUNO 25/05/2023
                        data_url = {
                            ...data_url,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID IN (${empIds.toString()})}'`
                            }]
                        }
                    } else {
                        data_url = {
                            ...data_url,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                            }]
                        }

                    }
                }
            }

            if (['NATUREZA'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = 'NATUREZA';
                const temRegistroNaEmpValor = await fazSelectNaEmpValor('', tabela);
                if (temRegistroNaEmpValor.length > 0) {
                    data_url = {
                        ...data_url,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                        }]
                    }
                }
            }

            if (['CADCONTA'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = 'CODIGO';
                const temRegistroNaEmpValor = await fazSelectNaEmpValor('', tabela);
                if (temRegistroNaEmpValor.length > 0) {
                    data_url = {
                        ...data_url,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                        }]
                    }
                }
            }

            if (['CLASSE_GER'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = 'CODIGO';
                const temRegistroNaEmpValor = await existeValorEmpValor(tabela);
                if (temRegistroNaEmpValor) {
                    data_url = {
                        ...data_url,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                        }]
                    }
                }
            }

            if (tabela == 'ENTIDADE') {
                const apenasClientesVinculadosAoRepresentante = (await verificaParametroRepresentanteUsuario()) && (retornaRepresentanteUsuario() != '');
                const isMaster = await uMasterOuSupervisor();
                if ((apenasClientesVinculadosAoRepresentante) && (!isMaster)) {
                    if (!data_url.where) {
                        data_url.where = [];
                    }
                    data_url = {
                        ...data_url,
                        where: [...data_url.where, `CODREP ='${retornaRepresentanteUsuario()}'`]
                    }
                }
            }

            if (empresa != '') {
                data_url = '/sisplan/funcoes/v1/pesquisa?JSON=' + JSON.stringify(data_url) + `&EMPRESA=_${empresa}`;
            } else {
                data_url = '/sisplan/funcoes/v1/pesquisa?JSON=' + JSON.stringify(data_url);
            }

            $(txtCod).unbind('pesquisou');
            $(txtCod).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            $("#pesquisaModalConfirmar").hide();
            $(t).off('click');
            $(t).click(async function () {
                var dataSet = [];
                var dataSetCols = [];
                var _url = "";
                // a url pode ser uma string ou uma function
                if (typeof (data_url) === "function") {
                    _url = data_url();
                } else {
                    _url = data_url;
                }
                //_url += _url != '' ? `&empresa=${empresa}&usuario=${usuario}` : `empresa=${empresa}&usuario=${usuario}`;
                // abre a tela da pesquisa
                $('#txtTabelaPesquisa').val(tabela);
                validaBotaoRedirecionar();
                $("#pesquisaModalLabel").text(await traduzSentenca('Pesquisa de ') + await traduzSentenca(caption.toLowerCase().replace('pesquisa de ', '').replace('pesquisa ', '')));
                $("#pesquisaModal").modal("show");
                $.LoadingOverlay("show");

                var response;
                try {
                    response = await requisicao('GET', '', _url, '', 10000);
                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro('Erro (' + error + ').');
                    $("#pesquisaModal").modal("hide");
                    return;
                }

                try {
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr['RESULT'][0].mensagem);
                        return;
                    }

                    var result = await response.json();

                    $.LoadingOverlay("hide");
                    if (result['RESULT'][0]) {
                        if (!result['RESULT'][0].length) {
                            dataSet.push(result['RESULT']);
                        } else {
                            dataSet = result['RESULT'][0];
                        }

                        if (!$.isEmptyObject(dataSet[0])) {
                            // preciso dinamicamente ter a relação com o nome das colunas para tabela
                            var keys = Object.keys(dataSet[0]);
                            for (let i = 0; i < keys.length; i++) {
                                if (['NUMERO', 'CODCLI', 'PED_CLI', 'CODIGO'].indexOf(keys[i].toUpperCase()) >= 0) {
                                    dataSetCols.push({ 'title': keys[i], 'data': keys[i], 'width': '80px' });
                                } else {
                                    dataSetCols.push({ 'title': keys[i], 'data': keys[i] });
                                }
                            }
                            // for (var k in keys) {
                            //     if (['NUMERO', 'CODCLI', 'PED_CLI', 'CODIGO'].indexOf(keys[k].toUpperCase()) >= 0) {
                            //         dataSetCols.push({ 'title': keys[k], 'data': keys[k], 'width': '80px' });
                            //     } else {
                            //         dataSetCols.push({ 'title': keys[k], 'data': keys[k] });
                            //     }
                            // }

                            $("#pesquisaModalBody").html('<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="pesquisaModalTable" ></table>');
                            //cria a tabela usando os dados e colunas
                            var table = $('#pesquisaModalTable').dataTable({
                                destroy: true,
                                order: false,
                                keys: true,
                                autoWidth: true,
                                "data": dataSet,
                                "columns": dataSetCols
                            });

                            $("body").keydown(function (e) {
                                const qtdeLinhas = $("#pesquisaModalTable tbody tr").length;
                                if (e.which === 80 && e.altKey) {
                                    e.preventDefault();
                                    $("input[type='search']").focus();
                                }
                                if (e.which === 13 && qtdeLinhas === 1) {
                                    $("#pesquisaModalTable tbody tr td")[0].click();
                                    table.$('tr.selected').removeClass('selected');
                                }
                            });

                            // desenha a seleção do registro clicaco
                            $('#pesquisaModalTable tbody').on('click', 'tr', function () {
                                if ($(this).hasClass('selected')) {
                                    $(this).removeClass('selected');
                                } else {
                                    table.$('tr.selected').removeClass('selected');
                                    $(this).addClass('selected');
                                }
                            });
                            // duplo click faz escolher o registro e fechar a pesquisa
                            $('#pesquisaModalTable tbody').on('dblclick', 'tr', function (e) {
                                e.preventDefault();
                                document.firstElementChild.style.zoom = "reset";
                                table.$('tr.selected').removeClass('selected');
                                $(this).addClass('selected');
                                $("#pesquisaModalSelecionar").click();
                            });
                            // botão selecionar
                            $("#pesquisaModalSelecionar").unbind('click');
                            $("#pesquisaModalSelecionar").click(function () {
                                var data = table.api().row('.selected').data();
                                if (data && data[pk_field].toString() && data[desc_field].toString()) {
                                    if ((simples != '') && (simples != undefined)) {
                                        $(txtCod).val(data[pk_field].toString());
                                        $(txtCod).attr('data-chave', data[pk_field].toString());
                                        $(txtCod).attr('data-desc', data[desc_field]);
                                    } else {
                                        $(txtCod).val('[' + data[pk_field].toString() + '] - ' + data[desc_field]);
                                        $(txtCod).attr('data-chave', data[pk_field].toString());
                                        $(txtCod).attr('data-desc', data[desc_field]);
                                    }
                                    $(txtCod).attr('data-selecionado', true);
                                    $(txtCod).trigger('pesquisou');
                                    $("#pesquisaModal").modal("hide");
                                } else {
                                    // $(txtCod).attr('data-selecionado', false);
                                }
                            });
                            // KeyTable ajuda a navegar na tabela com as teclas~
                            try {
                                var keytable = new $.fn.dataTable.KeyTable(table);
                                // se precionar enter executa duplo click
                                keytable.event.action(null, null, function (node) {
                                    $(node).dblclick();
                                });
                            } catch { }
                            // posiciona a navegacao via teclas no primeiro registro
                            if (dataSet.length >= 1) {
                                $("#pesquisaModalTable tbody tr td")[0].click();
                                table.$('tr.selected').removeClass('selected');
                            }
                        }
                    } else {
                        msgErro('Erro ao consultar dados, verifique a conexão.');
                        $("#pesquisaModal").modal("hide");
                    }

                    $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('d-flex');
                    $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('justify-content-end');
                    $('#pesquisaModalTable_wrapper .row > div').eq(1).prepend(`
                    <label style="display: flex;align-items: stretch;justify-content: flex-end;flex-direction: column;margin-right: 10px;">${await translateSentence('Tipo Pesquisa')}
                    <select class="input-default" name="selectPesquisa" id="selectPesquisa" style="
                        height: 30px;
                        max-width: 230px;">
                                <option value="0">${await translateSentence('Iniciando')}</option>
                                <option value="1" selected>${await translateSentence('Contendo a(s) Palavra(s)')}</option>
                                <option value="2">${await translateSentence('Contendo a Expressão')}</option>
                                <option value="3">${await translateSentence('Igual')}</option>
                    </select>
                    </label>`);
                } catch (error) {
                    console.log(error);
                    $.LoadingOverlay("hide");
                    msgErro('Erro ao consultar dados, verifique a conexão.');
                    $("#pesquisaModal").modal("hide");
                }

                // limpa evento
                //$("#pesquisaModalSelecionar").unbind('click');
                // seta o titulo da pesquisa

                $("#pesquisaModalSelecionar").show();
                // evento que controla quando a pesquisa fecha
                $('#pesquisaModal').unbind('hidden.bs.modal');
                $('#pesquisaModal').on('hidden.bs.modal', function (_) {
                    $('#pesquisaModalBody').empty();
                    $(txtCod).focus();
                });
            });
        }
    });

    jQuery.extend(jQuery.fn.dataTableExt.oSort, {
        "date-br-pre": function (a) {
            var brDatea = a.split('/');
            return (brDatea[2] + brDatea[1] + brDatea[0]);
        },

        "date-br-asc": function (a, b) {
            return ((a < b) ? -1 : ((a > b) ? 1 : 0));
        },

        "date-br-desc": function (a, b) {
            return ((a < b) ? 1 : ((a > b) ? -1 : 0));
        }
    });

    jQuery.fn.extend({
        autocompleta: async function (numCaracteres, $url, arrCampos, arrChaves, arrDescricoes, callback, bSimples, empresa = '', empIds = [], ignorarPesquisasPadroes) {
            $url = JSON.parse($url.substr(5, $url.length).trim())
            const tabela = $url.tabela.toUpperCase();
            $(this).unbind('keyup');
            $(this).on('keyup', function (event) {
                if ((event.keyCode != '13') && (event.keyCode != '9')) {
                    $(this).attr('data-selecionado', false);
                    $(this).attr('data-chave', '');
                    $(this).attr('data-desc', '');
                }
            });
            if (['REGIAO', 'REPRESEN'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const temRegistroNaEmpValor = await fazSelectNaEmpValor('', tabela);
                const campoChave = tabela.toUpperCase() == 'REGIAO' ? 'REGIAO' : 'CODREP';
                if (temRegistroNaEmpValor.length > 0) {
                    //CRIADO PARAMETRO EMPIDS PARA CASO SEJA NECESSÁRIO FAZER UM IN EM ALGUM SELECT DE PESQUISA QUE FAÇA PESQUISA NA TABELA REGIAO OU REPRESEN POIS CONSIDERA A EMP_VALOR
                    //TEM QUE PASSAR UM DISTINCT LA AONDE VAIS CHAMAR O AUTOCOMPLETA NO CAMPOS SELECT EX: "camposSelect": ["distinct codrep chave", "nome descricao"] -- BRUNO 25/05/2023
                    if (empIds.length > 0) {
                        $url = {
                            ...$url,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID IN (${empIds.toString()})}'`,
                            }]
                        }
                    } else {
                        $url = {
                            ...$url,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave).toUpperCase()} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                            }]
                        }
                    }

                }
            }
            if (['NATUREZA'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = 'NATUREZA';
                if (getCookie('naturezanaempvalor') == 'S') {
                    $url = {
                        ...$url,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                        }]
                    }
                }
            }
            if (['CLASSE_GER'].includes(tabela)) {
                const emp_id = getCookie('emp_id');
                const campoChave = 'CODIGO';
                const existeEmpValor = await existeValorEmpValor('CLASSE_GER')
                if (existeEmpValor) {
                    $url = {
                        ...$url,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${tabela}' AND EMP_VALOR.VALOR = ${(tabela + '.' + campoChave)} AND EMP_VALOR.EMP_ID = '${emp_id}'`
                        }]
                    }
                }
            }
            if (tabela == 'ENTIDADE') {
                const apenasClientesVinculadosAoRepresentante = (await verificaParametroRepresentanteUsuario()) && (retornaRepresentanteUsuario() != '');
                const isMaster = await uMasterOuSupervisor();
                if ((apenasClientesVinculadosAoRepresentante) && (!isMaster)) {
                    if (!$url.where) {
                        $url.where = [];
                    }
                    $url = {
                        ...$url,
                        where: [...$url.where, `CODREP ='${retornaRepresentanteUsuario()}'`]
                    }
                }
            }
            const consultaCliente = $url.tabela.toUpperCase() === 'ENTIDADE' && !ignorarPesquisasPadroes;
            const consultaPedido = $url.tabela.toUpperCase() === 'PEDIDO' && !ignorarPesquisasPadroes;
            const consultaNota = $url.tabela.toUpperCase() === 'NOTA';
            const consultaDocumento = $url.tabela.toUpperCase() === 'PA_MOV' && !ignorarPesquisasPadroes;
            const consultaReceber = $url.tabela.toUpperCase() === 'RECEBER';
            const consultaPagar = $url.tabela.toUpperCase() === 'PAGAR';
            const consultaReceberB = $url.tabela.toUpperCase() === 'RECEBERB';
            const consultaPagar1 = $url.tabela.toUpperCase() === 'PAGAR1';
            const consultaCor = $url.tabela.toUpperCase() === 'CADCOR';
            const consultaCorTin = $url.tabela.toUpperCase() === 'CADCORTIN';
            const consultaProduto = false;
            if (consultaCliente) {
                $url.camposSelect = ["CODCLI", "NOME", "CNPJ", "FANTASIA"];
            }
            if (consultaNota) {
                $url.camposSelect = ["FATURA", "SERIE"];
            }
            if (consultaCor) {
                $url.camposSelect = ["COR", "DESCRICAO"];
            }
            if (consultaCorTin) {
                $url.camposSelect = ["CODIGO", "DESCRICAO"];
            }
            if (consultaPedido) {
                $url.camposSelect = ["PEDIDO.NUMERO", "ENTIDADE.NOME"];
            }
            if (consultaDocumento) {
                $url.camposSelect = ["NUM_DOCTO", "DT_MVTO"];
                $url.camposWhereServerSide = ["NUM_DOCTO"];
            }
            if (consultaReceber) {
                $url.camposSelect = ["NUMERO", "CODCLI"];
                $url.camposWhereServerSide = ["NUMERO"];
            }
            if (consultaPagar) {
                $url.camposSelect = ["NUM_AP", "CODCRE"];
                $url.camposWhereServerSide = ["NUM_AP"];
            }
            if (consultaReceberB) {
                $url.camposSelect = ["LANCAMENTO", "NUMERO"];
                $url.camposWhereServerSide = ["LANCAMENTO"];
            }
            if (consultaPagar1) {
                $url.camposSelect = ["LANCAMENTO", "NUM_AP"];
                $url.camposWhereServerSide = ["LANCAMENTO"];
            }
            if (consultaProduto) {
                $url.camposSelect = ["CODIGO", "DESCRICAO"];
            }
            $url = 'JSON=' + JSON.stringify($url);
            var urlOrig = $url;

            var t = this;

            $(t).unbind('pesquisou');
            $(t).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            $(t).unbind('blur');
            $(t).on('blur', function () {
                if (($(t).attr('data-selecionado') == 'false') && ($(t).val() != '')) {
                    $(t).val('');
                    setTimeout(function () { $(t).focus() }, 150);
                }
            });
            var dados = [];
            const bListaServerSide = (consultaCliente ||
                consultaPedido ||
                consultaNota ||
                consultaDocumento ||
                consultaReceber ||
                consultaPagar ||
                consultaReceberB ||
                consultaCor ||
                consultaCorTin ||
                consultaProduto ||
                consultaPagar1);

            $(t).autocomplete({
                autoFocus: true,
                source: async function (request, response) {
                    const urlPadrao = (bListaServerSide) ? '/sisplan/funcoes/v1/pesquisadatatable?' : `/sisplan/funcoes/v1/pesquisa?`;
                    $url = (bListaServerSide) ? `${urlOrig}&START=0&LENGTH=100&CLIENTE=S&AUTOCOMPLETA=S&search[value]=${request.term}` : $url;
                    if (empresa != '') {
                        $url = $url.replaceAll(`&EMPRESA=_${empresa}`, '') + `&EMPRESA=_${empresa}`
                    }
                    await requisicao('GET', urlPadrao, $url, null)
                        .then(async function (retorno) {
                            const dataset = await retorno.json();
                            dados = await dataset['RESULT'][0];
                            if (consultaCorTin) {
                                dados = dados.map(dado => { return { ...dado, CHAVE: dado.CODIGO } });
                            }

                            dados.sort(function (a, b) {
                                let codigoA = a.CHAVE;
                                let codigoB = b.CHAVE;

                                return String(codigoA).localeCompare(codigoB, undefined, { numeric: true, sensitivity: 'base' });
                            });

                            let index = dados.findIndex(function (element, index) {
                                return element.CHAVE == request.term;
                            });

                            if (index != -1) {
                                let primeiroRegistro = dados[index];
                                dados.splice(index, 1);
                                dados.unshift(primeiroRegistro);
                            }

                            const array = await dados.map(function (value, index) {
                                if (consultaCliente) {
                                    value.CHAVE = value['CODCLI'];
                                    value.DESCRICAO = value['NOME'];
                                }
                                if (consultaPedido) {
                                    value.DESC_DEPOSITO = value['DESCRICAO'];
                                    value.CHAVE = value['NUMERO'];
                                    value.DESCRICAO = value['NOME'];
                                }
                                if (consultaNota) {
                                    value.CHAVE = value['FATURA'];
                                    value.DESCRICAO = value['SERIE'];
                                }
                                if (consultaCor) {
                                    value.CHAVE = value['COR'];
                                    value.DESCRICAO = value['DESCRICAO'];
                                }
                                if (consultaCorTin) {
                                    value.CHAVE = value['CODIGO'];
                                    value.DESCRICAO = value['DESCRICAO'];
                                }
                                if (consultaDocumento) {
                                    value.CHAVE = value["NUM_DOCTO"];
                                    value.DESCRICAO = value["DT_MVTO"];
                                }
                                if (consultaReceber) {
                                    value.CHAVE = value["NUMERO"];
                                    value.DESCRICAO = value["CODCLI"];
                                }
                                if (consultaPagar) {
                                    value.CHAVE = value["NUM_AP"];
                                    value.DESCRICAO = value["CODCRE"];
                                }
                                if (consultaReceberB) {
                                    value.CHAVE = value["LANCAMENTO"];
                                    value.DESCRICAO = value["NUMERO"];
                                }
                                if (consultaPagar1) {
                                    value.CHAVE = value["LANCAMENTO"];
                                    value.DESCRICAO = value["NUM_AP"];
                                }
                                if (consultaProduto) {
                                    value.CHAVE = value['CODIGO'];
                                    value.DESCRICAO = value['DESCRICAO'];
                                }
                                const keys = Object.keys(value);
                                const arrChaves = [];
                                for (var k in keys) {
                                    arrChaves.push(keys[k]);
                                }
                                const resultado = '[' + value.CHAVE + '] - ' + value.DESCRICAO;
                                return resultado;
                            });
                            response($.ui.autocomplete.filter(array, request.term));
                        });
                },
                minLength: numCaracteres,
                select: function (event, ui) {
                    var chave = pegaChave(ui.item.label, chave);
                    var data = dados.find(campoPesquisado => campoPesquisado.CHAVE == chave);
                    if (consultaCliente) {
                        data.CHAVE = data['CODCLI'];
                        data.DESCRICAO = data['NOME'];
                    }

                    if (arrCampos != undefined) {
                        for (let i = 0; i < arrCampos.length; i++) {
                            if (data[arrChaves[i]].toString()) {
                                if ((bSimples != undefined) && (bSimples[i] != '') && (bSimples[i] != undefined)) {
                                    setTimeout(() => {
                                        $(arrCampos[i]).val(data[arrChaves[i]].toString());
                                        $(arrCampos[i]).attr('data-chave', data[arrChaves[i]].toString());
                                        $(arrCampos[i]).attr('data-desc', data[arrDescricoes[i]]);
                                        $(arrCampos[i]).attr('data-selecionado', true);
                                    }, 0);
                                } else {
                                    $(arrCampos[i]).val('[' + data[arrChaves[i]].toString() + '] - ' + data[arrDescricoes[i]]);
                                    $(arrCampos[i]).attr('data-chave', data[arrChaves[i]].toString());
                                    $(arrCampos[i]).attr('data-desc', data[arrDescricoes[i]]);
                                    $(arrCampos[i]).attr('data-selecionado', true);
                                }
                            } else {
                                $(arrCampos[i]).val('');
                                $(arrCampos[i]).attr('data-chave', '');
                                $(arrCampos[i]).attr('data-desc', '');
                                $(arrCampos[i]).attr('data-selecionado', true);
                            }
                        }
                    }
                    $(t).attr('data-chave', chave);
                    $(t).attr('data-desc', data.DESCRICAO);
                    $(t).attr('data-selecionado', true);
                    $(t).trigger('pesquisou');
                },
                open: function () {
                    $(this).removeClass("ui-corner-all").addClass("ui-corner-top");
                },
                close: function () {
                    $(this).removeClass("ui-corner-top").addClass("ui-corner-all");
                }
            });
        }
    });

    jQuery.fn.extend({
        autocompletaSemDescricao: async function (numCaracteres, $url, campo, chave, callback, empresa = '') {
            $url = JSON.parse($url.substr(5, $url.length).trim())
            const tabela = $url.tabela.toUpperCase();
            $(this).unbind('keyup');
            $(this).on('keyup', function (event) {
                if ((event.keyCode != '13') && (event.keyCode != '9')) {
                    $(this).attr('data-selecionado', false);
                    $(this).attr('data-chave', '');
                    $(this).attr('data-desc', '');
                }
            });
            $url = 'JSON=' + JSON.stringify($url);
            var urlOrig = $url;

            var t = this;

            $(t).unbind('pesquisou');
            $(t).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            $(t).unbind('blur');
            $(t).on('blur', function () {
                if (($(t).attr('data-selecionado') == 'false') && ($(t).val() != '')) {
                    $(t).val('');
                    setTimeout(function () { $(t).focus() }, 150);
                }
            });
            var dados = [];

            $(t).autocomplete({
                autoFocus: true,
                source: async function (request, response) {
                    const urlPadrao = `/sisplan/funcoes/v1/pesquisa?`;
                    if (empresa != '') {
                        $url = $url.replaceAll(`&EMPRESA=_${empresa}`, '') + `&EMPRESA=_${empresa}`
                    }
                    await requisicao('GET', urlPadrao, $url, null)
                        .then(async function (retorno) {
                            const dataset = await retorno.json();
                            dados = await dataset['RESULT'][0];

                            dados.sort(function (a, b) {
                                let codigoA = a[chave];
                                let codigoB = b[chave];

                                return String(codigoA).localeCompare(codigoB, undefined, { numeric: true, sensitivity: 'base' });
                            });

                            let index = dados.findIndex(function (element, index) {
                                return element[chave] == request.term;
                            });

                            if (index != -1) {
                                let primeiroRegistro = dados[index];
                                dados.splice(index, 1);
                                dados.unshift(primeiroRegistro);
                            }

                            const array = await dados.map(function (value, index) {
                                const resultado = value[chave];
                                return resultado;
                            });
                            response($.ui.autocomplete.filter(array, request.term));
                        });
                },
                minLength: numCaracteres,
                select: function (event, ui) {
                    var campoChave = ui.item.label;
                    var data = dados.find(campoPesquisado => campoPesquisado[chave] == campoChave);

                    if (campo) {
                        if (data[chave].toString()) {
                            setTimeout(() => {
                                $(campo).val(data[chave].toString());
                                $(campo).attr('data-chave', data[chave].toString());
                                $(campo).attr('data-selecionado', true);
                            }, 0);
                        } else {
                            $(campo).val('');
                            $(campo).attr('data-chave', '');
                            $(campo).attr('data-desc', '');
                            $(campo).attr('data-selecionado', true);
                        }
                    }
                    $(t).attr('data-chave', chave);
                    $(t).attr('data-selecionado', true);
                    $(t).trigger('pesquisou');
                },
                open: function () {
                    $(this).removeClass("ui-corner-all").addClass("ui-corner-top");
                },
                close: function () {
                    $(this).removeClass("ui-corner-top").addClass("ui-corner-all");
                }
            });
        }
    });

    jQuery.fn.extend({
        habilita_tags: async function (placeholder) {
            $(this).select2({
                tags: [],
                multiple: true,
                placeholder: placeholder,
                language: {
                    noResults: function () {
                        return "Digite e aperte Enter para confirmar.";
                    }
                }
            });
        }
    });

    jQuery.fn.extend({
        pesquisa_varios: async function (data_url, chave, descricao) {
            $(this).on('click', async function () {
                async function retornaOpcoes() {
                    const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON=${data_url}`, null);
                    //   `JSON={ "tabela":"entidade", "camposSelect":["codcli", "nome"],"where": ["1=1"]}`, null);
                    // const jsonStr = await response.json();

                    if (!response) {
                        return [];
                    }

                    if (response.status != 200) {
                        console.error('erro ao buscar dados...');
                        return [];
                    }
                    const jsonStr = await response.json();
                    const retorno = jsonStr.RESULT[0];
                    return retorno;
                }

                const myOptions = await retornaOpcoes();
                myOptions.forEach((opt) => {
                    $(this).append(`<option value=${opt[chave]}>${opt[descricao]}</option`)
                });
                $(this).select2();
            });
        }
    });

    jQuery.fn.extend({
        async pesquisa_variosServerside(numCaracteres, data_url, chave, descricao) {
            let jsonPesquisa = JSON.parse(data_url);

            if (jsonPesquisa.tabela == 'ENTIDADE') {
                const apenasClientesVinculadosAoRepresentante = (await verificaParametroRepresentanteUsuario()) && (retornaRepresentanteUsuario() != '');
                const isMaster = await uMasterOuSupervisor();
                if ((apenasClientesVinculadosAoRepresentante) && (!isMaster)) {
                    if (!jsonPesquisa.where) {
                        jsonPesquisa.where = [];
                    }
                    jsonPesquisa = {
                        ...jsonPesquisa,
                        where: [...jsonPesquisa.where, `CODREP ='${retornaRepresentanteUsuario()}'`]
                    }
                    data_url = JSON.stringify(jsonPesquisa);
                }
            }

            if (jsonPesquisa.tabela == 'REGIAO') {
                const existeEmpValor = await fazSelectNaEmpValor('', 'REGIAO')
                if (existeEmpValor.length > 0) {
                    jsonPesquisa = {
                        ...jsonPesquisa,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${'REGIAO'}' AND EMP_VALOR.VALOR = ${('REGIAO' + '.' + 'REGIAO')} AND EMP_VALOR.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`
                        }],
                        where: [`EMP_VALOR.EMP_ID ='${getCookie('g_emp_id_empresa_logada')}'`]
                    }
                }
                data_url = JSON.stringify(jsonPesquisa);
            }

            if (jsonPesquisa.tabela == 'CLASSE_GER') {
                const existeEmpValor = await existeValorEmpValor('CLASSE_GER')
                if (existeEmpValor) {
                    jsonPesquisa = {
                        ...jsonPesquisa,
                        innerjoin: [{
                            "tabela": "EMP_VALOR",
                            "condicao": `EMP_VALOR.TABELA = '${'CLASSE_GER'}' AND EMP_VALOR.VALOR = ${('CLASSE_GER' + '.' + 'CODIGO')} AND EMP_VALOR.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`
                        }],
                        where: [`EMP_VALOR.EMP_ID ='${getCookie('g_emp_id_empresa_logada')}'`]
                    }
                }
                data_url = JSON.stringify(jsonPesquisa);
            }

            const urlPesquisa = data_url == '{}' ? `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/acessomenu/v1/telas?` : `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`;

            $(this).select2({
                ajax: {
                    url: urlPesquisa,
                    dataType: 'json',
                    type: 'GET',
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: function (params) {
                        const ajaxData = {
                            "EMPRESA": getCookie('empresa'),
                            "JSON": data_url,
                            "CLIENTE": 'S',
                            "START": 0,
                            "LENGTH": 100,
                            "AUTOCOMPLETA": 'S',
                            "search[value]": params.term,
                            "TIPO_PESQUISA": $('#selectPesquisa').val() ?? ''
                        };
                        return ajaxData;
                    },
                    processResults: function (response) {
                        const retorno = response.RESULT[0];
                        const newOption = [];
                        retorno.forEach((dado) => {
                            const option = {
                                id: dado[chave],
                                text: `[${dado[chave]}] - ${dado[descricao]}`
                            };
                            newOption.push(option);
                        });
                        return {
                            results: newOption
                        };

                    },
                },
                multiple: true,
                allowClear: false,
                placeholder: $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P'],
                language: {
                    inputTooShort: function (e) {
                        if (e.input == '') {
                            return `${$traducaoDigite[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']} ${numCaracteres} ${$traducaoBuscar[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']}`;
                        } else if (e.input.length < numCaracteres) {
                            return `${$traducaoDigite[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']} ${numCaracteres - e.input.length} ${$traducaoBuscar[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']}`
                        }
                    },
                    noResults: function () {
                        return 'Nenhum registro encontrado.'
                    }
                },
                minimumInputLength: numCaracteres,

            });

            const id = $(this)[0].id;
            $($($($(this).parent().children()[1]).children()[0]).children().children()[0]).addClass(id);

            const maxWidth = parseFloat($(`.${id}`).css('width')) - 3;
            $('.select2.select2-container.select2-container--default').css('flex', '1');
            $('.select2-search__field').attr('style', function (i, s) { return s + 'height: 100% !important;' });
            //$('.select2-selection__rendered').attr('style', function(i, s) { return s + 'overflow: hidden !important;' });

            if ($(`.select2-selection__rendered.${id}`).length > 0) {
                $(`.select2-selection__rendered.${id}`).off('focusout');
                $(`.select2-selection__rendered.${id}`).on('focusout', function () {
                    $(`.select2-selection__rendered.${id}`).scrollTop(0)
                });


                $(`.select2-selection__rendered.${id}`)[0].style.position = "absolute";
                $(`.select2-selection__rendered.${id}`)[0].style.zIndex = 99999999;

                $(`.select2-selection__rendered.${id}`).on("keydown", function (e) {
                    setTimeout(() => { $(".select2-results").removeClass("d-none"); }, 200);
                })

            } else {
                $(`.select2-selection__rendered`)[0].style.position = "absolute";
                $(`.select2-selection__rendered`)[0].style.zIndex = 99999999;

                $(`.select2-selection__rendered`).on("keydown", function (e) {
                    setTimeout(() => { $(".select2-results").removeClass("d-none"); }, 200);
                })

            }

            function ajustarPosicaoDropdown(componente) {
                const distancia = $(componente).outerHeight() - parseFloat('36px');
                // 
                const tamanhoModal = $('#modal-filtros .modal-content').height();
                const meioModal = tamanhoModal / 2;
                const posicaoTopComponente = $(componente).offset().top;


                if (posicaoTopComponente > meioModal) {
                    $(componente).css('top', `-${distancia}px`);
                }

                $(componente).css('z-index', '999999999');
            }

            // $(`.${id}`).css('max-width', `${maxWidth}px`);
            $(this).on('select2:open', function () {
                $('.select2-search__field').keyup(function (e) {
                    if (e.keyCode == 115) {
                        const idBotaoPesquisa = this.parentElement.parentElement.parentElement.parentElement.parentElement.parentElement.children[2].children[0].id
                        $(`#${idBotaoPesquisa}`).trigger('click')
                        e.preventDefault();
                        e.stopPropagation();
                    };
                });

                $('.select2-selection__rendered').css('z-index', ''); // remove z-index de todos os select
                $(this).siblings('.select2-container').find('.select2-selection__rendered').css('z-index', '99999999'); // adiciona z-index no select aberto
                if ($(`.${id}`).length > 0) {
                    $(`.${id}`).css('height', '');
                } else {
                    $(".select2-selection__rendered").css('height', '');
                }

                if ($(this).val().length > 0 && $(".select2-search__field").val() != "") {
                    $(".select2-results").removeClass("d-none");
                    ajustarPosicaoDropdown(`.${id}`);
                    $(`.${id}`).css('z-index', '999999999');
                } else if ($(this).val().length > 0) {
                    $(".select2-results").addClass("d-none");
                    ajustarPosicaoDropdown(`.${id}`);
                } else {
                    $(".select2-results").removeClass("d-none");
                }
            });

            $(this).on('select2:close', function () {
                if ($(`.${id}`).length > 0) {
                    $(`.${id}`).css('height', '94%');
                    $(`.select2-search__field`).attr('placeholder', $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']);
                } else {
                    $(".select2-selection__rendered").css('height', '94%');
                }
                // $('.select2-selection__rendered').scrollTop(0)
            });

            $(`#${id}`).on('select2:closing', function () {
                setTimeout(() => {
                    $('.select2-search__field').attr('placeholder', $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']);
                    $(`.${id}`).css('top', 'auto');
                    // $('.select2-selection__rendered').scrollTop(0)
                }, 0);
            });

            $(`#${id}`).on("select2:unselecting", function (e) {
                setTimeout(() => {
                    ajustarPosicaoDropdown(`.${id}`);
                    // $('.select2-selection__rendered').scrollTop(0)
                }, 5);
            });

            $(this).val(null).trigger('change');
        }
    });

    jQuery.fn.extend({
        pesquisaVariosDadosEstaticos: async function (numCaracteres, dados) {
            const select = {
                data: dados,
                multiple: true,
                allowClear: false,
                placeholder: $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P'],
                language: {
                    inputTooShort: function (e) {
                        if (e.input == '') {
                            return `${$traducaoDigite[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']} ${numCaracteres} ${$traducaoBuscar[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']}`;
                        } else if (e.input.length < numCaracteres) {
                            return `${$traducaoDigite[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']} ${numCaracteres - e.input.length} ${$traducaoBuscar[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']}`
                        }
                    },
                    noResults: function () {
                        return 'Nenhum registro encontrado.'
                    }
                },
            }

            if (numCaracteres > 0) {
                select.minimumInputLength = numCaracteres
            }

            $(this).select2(select)

            const id = $(this)[0].id
            $($($($(this).parent().children()[1]).children()[0]).children().children()[0]).addClass(id)

            $('.select2.select2-container.select2-container--default').css('flex', '1')
            $('.select2-search__field').attr('style', function (i, s) { return s + 'height: 100% !important;' })

            if ($(`.select2-selection__rendered.${id}`).length > 0) {
                $(`.select2-selection__rendered.${id}`).off('focusout');
                $(`.select2-selection__rendered.${id}`).on('focusout', function () {
                    $(`.select2-selection__rendered.${id}`).scrollTop(0)
                })

                $(`.select2-selection__rendered.${id}`)[0].style.position = "absolute"
                $(`.select2-selection__rendered.${id}`)[0].style.zIndex = 99999999

                $(`.select2-selection__rendered.${id}`).on("keydown", function (e) {
                    setTimeout(() => { $(".select2-results").removeClass("d-none") }, 200)
                })

            } else {
                $(`.select2-selection__rendered`)[0].style.position = "absolute"
                $(`.select2-selection__rendered`)[0].style.zIndex = 99999999

                $(`.select2-selection__rendered`).on("keydown", function (e) {
                    setTimeout(() => { $(".select2-results").removeClass("d-none") }, 200)
                })

            }

            function ajustarPosicaoDropdown(componente) {
                const distancia = $(componente).outerHeight() - parseFloat('36px')
                const tamanhoModal = $('#modal-filtros .modal-content').height()
                const meioModal = tamanhoModal / 2
                const posicaoTopComponente = $(componente).offset().top


                if (posicaoTopComponente > meioModal) {
                    $(componente).css('top', `-${distancia}px`)
                }

                $(componente).css('z-index', '999999999')
            }

            $(this).on('select2:open', function () {
                let marginTop = 0
                const quantidadeItensAdicionados = $(this).val().length
                if (quantidadeItensAdicionados > 0 && quantidadeItensAdicionados <= 3) marginTop = (38 * quantidadeItensAdicionados) - (quantidadeItensAdicionados - 1)
                if (quantidadeItensAdicionados > 3) marginTop = 112

                $('.select2-selection__rendered').css('z-index', '')
                $('.select2-selection__rendered').css('margin-top', `-${marginTop}px`)
                $(this).siblings('.select2-container').find('.select2-selection__rendered').css('z-index', '99999999')
                if ($(`.${id}`).length > 0) {
                    $(`.${id}`).css('height', '')
                } else {
                    $(".select2-selection__rendered").css('height', '')
                }
                if (quantidadeItensAdicionados > 0 && (($(".select2-search__field").val() != "" && numCaracteres > 0) || (numCaracteres === 0))) {
                    $(".select2-results").removeClass("d-none")
                    ajustarPosicaoDropdown(`.${id}`)
                    $(`.${id}`).css('z-index', '999999999')
                } else if (quantidadeItensAdicionados > 0) {
                    $(".select2-results").addClass("d-none")
                    ajustarPosicaoDropdown(`.${id}`)
                } else {
                    $(".select2-results").removeClass("d-none")
                }
            });

            $(this).on('select2:close', function () {
                $('.select2-selection__rendered').css('margin-top', '0')
                if ($(`.${id}`).length > 0) {
                    $(`.${id}`).css('height', '94%')
                    $(`.select2-search__field`).attr('placeholder', $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P'])
                } else {
                    $(".select2-selection__rendered").css('height', '94%')
                }
            });

            $(`#${id}`).on('select2:closing', function () {
                setTimeout(() => {
                    $('.select2-search__field').attr('placeholder', $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P'])
                    $(`.${id}`).css('top', 'auto')
                }, 0)
            })

            $(`#${id}`).on("select2:unselecting", function (e) {
                setTimeout(() => {
                    ajustarPosicaoDropdown(`.${id}`)
                }, 5)
            })

            $(this).val(null).trigger('change')
        }
    })

    jQuery.fn.extend({
        listaFiltros: async function () {
            let arrayCodigos = [];
            let id = $(this)[0].id.replace('txt', '');
            let placeholder = $(this)[0].placeholder;
            $(this).parent().append(`<div class="input-group-bottom" style="display: contents;"">` +
                `<textarea style="overflow:hidden; resize: none; min-height: 22px;" type="text" disabled="" class="col-lg-12 col-12 input-default focus form-control d-none" id="lista${id}"` +
                `placeholder="Lista de ${placeholder}"></textarea>` +
                `</div>`);

            $(`#lista${id}`).css('height', "22px");
            $(`#lista${id}`).on('input', () => {
                $(`#lista${id}`).css('height', ($(`#lista${id}`)[0].scrollHeight + 5) + "px");
            });

            $(this).on('focus', async function () {

                if ($(`#lista${id}`)[0].textLength == 0) {
                    $(`#lista${id}`).css('height', `22px`);
                }

                if ($(`#lista${id}`).val() == '') {
                    arrayCodigos = [];
                }

                $(`#lista${id}`).css('height', ($(`#lista${id}`)[0].scrollHeight + 5) + "px");
                $(`#lista${id}`).removeClass('d-none');
            });

            $(this).on('focusout', async function () {
                if ($(this).val().slice(0, 1) == '[') {
                    if (arrayCodigos.find(cod => cod == pegaChave(this)) != undefined) {
                        return;
                    }
                    let codigo;
                    if ($(`#lista${id}`).val() == '') {
                        codigo = pegaChave(this);
                    } else {
                        codigo = pegaChave(this) + ',' + $(`#lista${id}`).val();
                    }
                    $(`#lista${id}`).val(codigo);
                    arrayCodigos.push(pegaChave(this));
                    $(this).val('');
                }

                if ($(`#lista${id}`).val() == '') {
                    $(`#lista${id}`).addClass('d-none');
                } else {
                    $(`#lista${id}`).css('height', '22px');
                }

            });

            $(this).on('keypress', function (e) {
                if (e.which == 13) {
                    if ($(this).val().slice(0, 1) == '[') {
                        if (arrayCodigos.find(cod => cod == pegaChave(this)) != undefined) {
                            let lista = $(`#lista${id}`).val().split(',');
                            lista = lista.filter(cod => (cod != pegaChave(this)));
                            arrayCodigos = lista;
                            $(`#lista${id}`).val(lista);
                            $(this).val('');
                            return;
                        }
                        let codigo;
                        if ($(`#lista${id}`).val() == '') {
                            codigo = pegaChave(this);
                        } else {
                            codigo = pegaChave(this) + ',' + $(`#lista${id}`).val();
                        }
                        $(`#lista${id}`).val(codigo);
                        arrayCodigos.push(pegaChave(this));
                        $(this).val('');
                    }
                    $(`#lista${id}`).css('height', ($(`#lista${id}`)[0].scrollHeight) + "px");
                }
                if (e.which == 45) {
                    if ($(this).val().slice(0, 1) == '[') {
                        let lista = $(`#lista${id}`).val().split(',');
                        lista = lista.filter(cod => (cod != pegaChave(this)));
                        arrayCodigos = lista;
                        $(`#lista${id}`).val(lista);
                        $(this).val('');
                    }

                }

            });

            $(this).on("input", function () {
                if ($(this).val() == '-') {
                    $(this).val('');
                }
            });

        }
    });

    jQuery.fn.extend({
        pesquisa_serverside: function (arr_txtCod, arr_pk_field, arr_desc_field, data_url, caption, callback, bSimples, pEmpresa = '', pAtivo = '') {
            var t = this;

            $(t).unbind('pesquisou');
            $(t).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            $(arr_txtCod[0]).keyup(function (e) {
                if (e.keyCode == 115) {
                    $(t).click();
                    e.preventDefault();
                    e.stopPropagation();
                }
            });

            $(t).unbind('click');
            $(t).click(async function () {
                let jsonPesquisa = JSON.parse(data_url);
                if (jsonPesquisa.tabela.toUpperCase() == 'ENTIDADE') {

                    const apenasClientesVinculadosAoRepresentante = (await verificaParametroRepresentanteUsuario()) && (retornaRepresentanteUsuario() != '');
                    const isMaster = await uMasterOuSupervisor();
                    if (pAtivo == 'S') {
                        $('#cbAtivo').removeAttr('hidden');
                        $('#lblAtivo').removeAttr('hidden');
                        if (localStorage.getItem('pesquisaClienteAtivo')) {
                            const cbAtivo = localStorage.getItem('pesquisaClienteAtivo') == 'true' ? true : false;
                            $('#cbAtivo').prop('checked', cbAtivo);
                        }
                        const ativo = $('#cbAtivo').is(':checked') ? `ENTIDADE.ATIVO = 'S'` : '';

                        if (ativo != '') {
                            if (!jsonPesquisa.where) {
                                jsonPesquisa.where = [];
                            }
                            jsonPesquisa = {
                                ...jsonPesquisa,
                                where: [...jsonPesquisa.where, ativo]
                            }
                            data_url = JSON.stringify(jsonPesquisa);
                        } else {
                            jsonPesquisa.where = jsonPesquisa.where.filter(function (condicao) {
                                return condicao !== `ENTIDADE.ATIVO = 'S'`;
                            });
                        }
                    }

                    if ((apenasClientesVinculadosAoRepresentante) && (!isMaster)) {
                        if (!jsonPesquisa.where) {
                            jsonPesquisa.where = [];
                        }
                        jsonPesquisa = {
                            ...jsonPesquisa,
                            where: [...jsonPesquisa.where, `ENTIDADE.CODREP ='${retornaRepresentanteUsuario()}'`]
                        }
                        data_url = JSON.stringify(jsonPesquisa);
                    }
                }

                if (jsonPesquisa.tabela.toUpperCase() == 'REGIAO') {
                    const existeEmpValor = await fazSelectNaEmpValor('', 'REGIAO')
                    if (!jsonPesquisa.where) {
                        jsonPesquisa.where = [];
                    }
                    if (!jsonPesquisa.innerJoin) {
                        jsonPesquisa.innerJoin = [];
                    }
                    if (existeEmpValor.length > 0) {
                        jsonPesquisa = {
                            ...jsonPesquisa,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${'REGIAO'}' AND EMP_VALOR.VALOR = ${('REGIAO' + '.' + 'REGIAO')} AND EMP_VALOR.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`
                            }],
                            where: [...jsonPesquisa.where, `EMP_VALOR.EMP_ID ='${getCookie('g_emp_id_empresa_logada')}'`]
                        }
                    }
                    const verificaSeExiste = await retornaJsonPesquisaPadrao(JSON.stringify(jsonPesquisa));
                    if (verificaSeExiste.length <= 0) {
                        delete jsonPesquisa.innerjoin
                        jsonPesquisa.where.forEach((item, index) => {
                            if (item.includes('EMP_VALOR.EMP_ID')) {
                                jsonPesquisa.where.splice(index, 1);
                            }
                        });
                    }
                    data_url = JSON.stringify(jsonPesquisa);
                }

                if (jsonPesquisa.tabela.toUpperCase() == 'CLASSE_GER') {
                    const existeEmpValor = await existeValorEmpValor('CLASSE_GER')
                    if (!jsonPesquisa.where) {
                        jsonPesquisa.where = [];
                    }
                    if (!jsonPesquisa.innerJoin) {
                        jsonPesquisa.innerJoin = [];
                    }
                    if (existeEmpValor) {
                        jsonPesquisa = {
                            ...jsonPesquisa,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${'CLASSE_GER'}' AND EMP_VALOR.VALOR = ${('CLASSE_GER' + '.' + 'CODIGO')} AND EMP_VALOR.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`
                            }],
                            where: [...jsonPesquisa.where, `EMP_VALOR.EMP_ID ='${getCookie('g_emp_id_empresa_logada')}'`]
                        }
                    }
                    const verificaSeExiste = await retornaJsonPesquisaPadrao(JSON.stringify(jsonPesquisa));
                    if (verificaSeExiste.length <= 0) {
                        delete jsonPesquisa.innerjoin
                        jsonPesquisa.where.forEach((item, index) => {
                            if (item.includes('EMP_VALOR.EMP_ID')) {
                                jsonPesquisa.where.splice(index, 1);
                            }
                        });
                    }
                    data_url = JSON.stringify(jsonPesquisa);
                }

                $("#pesquisaModalLabel").text(await traduzSentenca('Pesquisa de ') + await traduzSentenca(caption.toLowerCase().replace('pesquisa de ', '').replace('pesquisa ', '')));
                $("#pesquisaModal").modal("show");
                $.LoadingOverlay("show");
                let camposTabela = '';
                let novaDataUrl = JSON.parse(data_url)
                if (JSON.parse(data_url).camposSelectSubSelect != undefined) {
                    for (let i = 0; i < JSON.parse(data_url).camposSelectSubSelect.length; i++) {
                        camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelectSubSelect[i]}</th>`
                    };
                    novaDataUrl.orderBy = [`${JSON.parse(data_url).camposSelectSubSelect[0]} ASC`]
                    data_url = JSON.stringify(novaDataUrl);
                } else {
                    for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                        camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelect[i].includes(' AS ') ? JSON.parse(data_url).camposSelect[i].split(' AS ')[1] : JSON.parse(data_url).camposSelect[i]}</th>`
                    };
                    novaDataUrl.orderBy = [`${JSON.parse(data_url).camposSelect[0]} ASC`]
                    data_url = JSON.stringify(novaDataUrl);
                }
                $('#txtTabelaPesquisa').val(JSON.parse(data_url).tabela.toUpperCase());
                validaBotaoRedirecionar();
                try {
                    const protocolo = getCookie('protocolo');
                    $("#pesquisaModalBody").html(`<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="pesquisaModalTable" ><thead><tr>${camposTabela}</tr></thead><tbody></tbody></table>`);
                    let isOrdering = false;
                    var table = $('#pesquisaModalTable').DataTable({
                        destroy: true,
                        lengthChange: false,
                        autoWidth: true,
                        serverSide: true,
                        processing: true,
                        ajax: {
                            url: `${protocolo}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                            type: "GET",
                            headers: { 'Authorization': BASIC_AUTH },
                            data: function (d) {
                                d.EMPRESA = pEmpresa != '' ? pEmpresa : getCookie('empresa')
                                d.USUARIO = getCookie('usuario').toUpperCase()
                                d.JSON = data_url
                                d.CLIENTE = caption == 'Pesquisa Cliente' ? 'S' : 'N'
                                d.TIPO_PESQUISA = $('#selectPesquisa').val() ?? ''
                            }
                        },
                    });

                    $('#pesquisaModalTable').on('order.dt', function () {
                        if (!isOrdering) {
                            isOrdering = true;
                            const order = table.order();
                            const colIndex = order[0][0];
                            const dir = order[0][1];

                            let novaDataUrl = JSON.parse(data_url);

                            if (novaDataUrl.camposSelectSubSelect != undefined) {
                                novaDataUrl.orderBy = [`${novaDataUrl.camposSelectSubSelect[colIndex]} ${dir.toUpperCase()}`];
                            } else {
                                novaDataUrl.orderBy = [`${novaDataUrl.camposSelect[colIndex]} ${dir.toUpperCase()}`];
                            }

                            data_url = JSON.stringify(novaDataUrl);

                            table.ajax.reload(function () {
                                isOrdering = false;
                            });
                        }
                    })

                    $('#pesquisaModalTable').on('xhr.dt', function (e, settings, json, xhr) {
                        isOrdering = false;
                    });

                    setTimeout(() => {
                        $("input[type='search']").focus();
                    }, 500);

                    $('#pesquisaModalTable tbody').on('click', 'tr', function () {
                        if ($(this).hasClass('selected')) {
                            $(this).removeClass('selected');
                        } else {
                            $('#pesquisaModalTable').DataTable().$('tr.selected').removeClass('selected');
                            $(this).addClass('selected');
                        }
                    });

                    $('#pesquisaModalTable tbody').on('dblclick', 'tr', function (e) {
                        e.preventDefault();
                        document.firstElementChild.style.zoom = "reset";
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        $("#pesquisaModalSelecionar").click();
                    });

                    $("#pesquisaModalSelecionar").unbind('click');
                    $("#pesquisaModalSelecionar").click(function () {
                        var data = table.row('.selected').data();
                        var dataAux = data;
                        data = {};
                        if (JSON.parse(data_url).camposSelectSubSelect) {
                            for (let i = 0; i < JSON.parse(data_url)?.camposSelectSubSelect.length; i++) {
                                let alias = JSON.parse(data_url)?.camposSelectSubSelect[i];
                                if (alias.includes(' AS ')) {
                                    alias = alias.split(' AS ')[1];
                                }
                                data[alias] = dataAux[i]
                            };
                        } else {
                            for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                                let alias = JSON.parse(data_url).camposSelect[i];
                                if (alias.includes(' AS ')) {
                                    alias = alias.split(' AS ')[1];
                                }
                                data[alias] = dataAux[i]
                            };
                        }
                        for (var i in arr_pk_field) {
                            if (data && data[arr_pk_field[i]].toString() && data[arr_desc_field[i]].toString()) {
                                if ((bSimples != undefined) && (bSimples[i] != '') && (bSimples[i] != undefined)) {
                                    $(arr_txtCod[i]).val(data[arr_pk_field[i]].toString());
                                } else {
                                    $(arr_txtCod[i]).val('[' + data[arr_pk_field[i]].toString() + '] - ' + data[arr_desc_field[i]]);
                                }
                                $(arr_txtCod[i]).attr('data-selecionado', true);
                                $(arr_txtCod[i]).attr('data-chave', data[arr_pk_field[i]]);
                                $(arr_txtCod[i]).attr('data-desc', data[arr_desc_field[i]]);
                                $("#pesquisaModal").modal("hide");
                            }
                        }
                        $(t).trigger('pesquisou');
                    });

                    $("#cbAtivo").unbind('click');
                    $("#cbAtivo").click(function () {
                        localStorage.setItem('pesquisaClienteAtivo', $(this).is(':checked'));
                        $(t).trigger('click');
                    });


                    $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('d-flex');
                    $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('justify-content-end');
                    $('#pesquisaModalTable_wrapper .row > div').eq(1).prepend(`
                    <label style="display: flex;align-items: stretch;justify-content: flex-end;flex-direction: column;margin-right: 10px;">${await translateSentence('Tipo Pesquisa')}
                    <select class="input-default" name="selectPesquisa" id="selectPesquisa" style="
                        height: 30px;
                        max-width: 230px;">
                                <option value="0">${await translateSentence('Iniciando')}</option>
                                <option value="1" selected>${await translateSentence('Contendo a(s) Palavra(s)')}</option>
                                <option value="2">${await translateSentence('Contendo a Expressão')}</option>
                                <option value="3">${await translateSentence('Igual')}</option>
                    </select>
                    </label>`);

                } catch (error) {
                    console.log(error)
                    $.LoadingOverlay("hide");
                    msgErro('Erro ao consultar dados, verifique a conexão.');
                    $("#pesquisaModal").modal("hide");
                }

                $.LoadingOverlay("hide");
                $("#pesquisaModalSelecionar").show();
                $("#pesquisaModalConfirmar").hide();
                $("#pesquisaModal").unbind('hidden.bs.modal');
                $('#pesquisaModal').on('hidden.bs.modal', function (_) {
                    $('#pesquisaModalBody').empty();
                    $(arr_txtCod[0]).focus();
                    $('#cbAtivo').attr('hidden', true);
                    $('#lblAtivo').attr('hidden', true);
                });

            });
        }
    });

    jQuery.fn.extend({
        pesquisaServersideSemDescricao: function (arr_txtCod, arr_pk_field, data_url, caption, callback, bSimples, pEmpresa = '', pAtivo = '') {
            var t = this;

            $(t).unbind('pesquisou');
            $(t).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            $(arr_txtCod[0]).keyup(function (e) {
                if (e.keyCode == 115) {
                    $(t).click();
                    e.preventDefault();
                    e.stopPropagation();
                }
            });

            $(t).unbind('click');
            $(t).click(async function () {
                $("#pesquisaModalLabel").text(await traduzSentenca('Pesquisa de ') + await traduzSentenca(caption.toLowerCase().replace('pesquisa de ', '').replace('pesquisa ', '')));
                $("#pesquisaModal").modal("show");
                $.LoadingOverlay("show");
                let camposTabela = '';
                let novaDataUrl = JSON.parse(data_url)
                if (JSON.parse(data_url).camposSelectSubSelect != undefined) {
                    for (let i = 0; i < JSON.parse(data_url).camposSelectSubSelect.length; i++) {
                        camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelectSubSelect[i]}</th>`
                    };
                    novaDataUrl.orderBy = [`${JSON.parse(data_url).camposSelectSubSelect[0]} ASC`]
                    data_url = JSON.stringify(novaDataUrl);
                } else {
                    for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                        camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelect[i].includes(' AS ') ? JSON.parse(data_url).camposSelect[i].split(' AS ')[1] : JSON.parse(data_url).camposSelect[i]}</th>`
                    };
                    novaDataUrl.orderBy = [`${JSON.parse(data_url).camposSelect[0]} ASC`]
                    data_url = JSON.stringify(novaDataUrl);
                }
                $('#txtTabelaPesquisa').val(JSON.parse(data_url).tabela.toUpperCase());
                validaBotaoRedirecionar();
                try {
                    const protocolo = getCookie('protocolo');
                    $("#pesquisaModalBody").html(`<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="pesquisaModalTable" ><thead><tr>${camposTabela}</tr></thead><tbody></tbody></table>`);
                    let isOrdering = false;
                    var table = $('#pesquisaModalTable').DataTable({
                        destroy: true,
                        lengthChange: false,
                        autoWidth: true,
                        serverSide: true,
                        processing: true,
                        ajax: {
                            url: `${protocolo}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                            type: "GET",
                            headers: { 'Authorization': BASIC_AUTH },
                            data: function (d) {
                                d.EMPRESA = pEmpresa != '' ? pEmpresa : getCookie('empresa')
                                d.USUARIO = getCookie('usuario').toUpperCase()
                                d.JSON = data_url
                                d.CLIENTE = caption == 'Pesquisa Cliente' ? 'S' : 'N'
                                d.TIPO_PESQUISA = $('#selectPesquisa').val() ?? ''
                            }
                        },
                    });

                    $('#pesquisaModalTable').on('order.dt', function () {
                        if (!isOrdering) {
                            isOrdering = true;
                            const order = table.order();
                            const colIndex = order[0][0];
                            const dir = order[0][1];

                            let novaDataUrl = JSON.parse(data_url);

                            if (novaDataUrl.camposSelectSubSelect != undefined) {
                                novaDataUrl.orderBy = [`${novaDataUrl.camposSelectSubSelect[colIndex]} ${dir.toUpperCase()}`];
                            } else {
                                novaDataUrl.orderBy = [`${novaDataUrl.camposSelect[colIndex]} ${dir.toUpperCase()}`];
                            }

                            data_url = JSON.stringify(novaDataUrl);

                            table.ajax.reload(function () {
                                isOrdering = false;
                            });
                        }
                    })

                    $('#pesquisaModalTable').on('xhr.dt', function (e, settings, json, xhr) {
                        isOrdering = false;
                    });

                    setTimeout(() => {
                        $("input[type='search']").focus();
                    }, 500);

                    $('#pesquisaModalTable tbody').on('click', 'tr', function () {
                        if ($(this).hasClass('selected')) {
                            $(this).removeClass('selected');
                        } else {
                            $('#pesquisaModalTable').DataTable().$('tr.selected').removeClass('selected');
                            $(this).addClass('selected');
                        }
                    });

                    $('#pesquisaModalTable tbody').on('dblclick', 'tr', function (e) {
                        e.preventDefault();
                        document.firstElementChild.style.zoom = "reset";
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        $("#pesquisaModalSelecionar").click();
                    });

                    $("#pesquisaModalSelecionar").unbind('click');
                    $("#pesquisaModalSelecionar").click(function () {
                        var data = table.row('.selected').data();
                        var dataAux = data;
                        data = {};
                        if (JSON.parse(data_url).camposSelectSubSelect) {
                            for (let i = 0; i < JSON.parse(data_url).camposSelectSubSelect.length; i++) {
                                let alias = JSON.parse(data_url).camposSelectSubSelect[i];
                                if (alias.includes(' AS ')) {
                                    alias = alias.split(' AS ')[1];
                                }
                                data[alias] = dataAux[i]
                            };
                        } else {
                            for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                                let alias = JSON.parse(data_url).camposSelect[i];
                                if (alias.includes(' AS ')) {
                                    alias = alias.split(' AS ')[1];
                                }
                                data[alias] = dataAux[i]
                            };
                        }

                        for (var i in arr_pk_field) {
                            if (data && data[arr_pk_field[i]].toString()) {
                                if ((bSimples != undefined) && (bSimples[i] != '') && (bSimples[i] != undefined)) {
                                    $(arr_txtCod[i]).val(data[arr_pk_field[i]].toString());
                                } else {
                                    $(arr_txtCod[i]).val(data[arr_pk_field[i]].toString());
                                }
                                $(arr_txtCod[i]).attr('data-selecionado', true);
                                $(arr_txtCod[i]).attr('data-chave', data[arr_pk_field[i]]);
                                $("#pesquisaModal").modal("hide");
                            }
                        }
                        $(t).trigger('pesquisou');
                    });

                    $("#cbAtivo").unbind('click');
                    $("#cbAtivo").click(function () {
                        localStorage.setItem('pesquisaClienteAtivo', $(this).is(':checked'));
                        $(t).trigger('click');
                    });


                    $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('d-flex');
                    $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('justify-content-end');
                    $('#pesquisaModalTable_wrapper .row > div').eq(1).prepend(`
                    <label style="display: flex;align-items: stretch;justify-content: flex-end;flex-direction: column;margin-right: 10px;">${await translateSentence('Tipo Pesquisa')}
                    <select class="input-default" name="selectPesquisa" id="selectPesquisa" style="
                        height: 30px;
                        max-width: 230px;">
                                <option value="0">${await translateSentence('Iniciando')}</option>
                                <option value="1" selected>${await translateSentence('Contendo a(s) Palavra(s)')}</option>
                                <option value="2">${await translateSentence('Contendo a Expressão')}</option>
                                <option value="3">${await translateSentence('Igual')}</option>
                    </select>
                    </label>`);

                } catch (error) {
                    console.log(error)
                    $.LoadingOverlay("hide");
                    msgErro('Erro ao consultar dados, verifique a conexão.');
                    $("#pesquisaModal").modal("hide");
                }

                $.LoadingOverlay("hide");
                $("#pesquisaModalSelecionar").show();
                $("#pesquisaModalConfirmar").hide();
                $("#pesquisaModal").unbind('hidden.bs.modal');
                $('#pesquisaModal').on('hidden.bs.modal', function (_) {
                    $('#pesquisaModalBody').empty();
                    $(arr_txtCod[0]).focus();
                    $('#cbAtivo').attr('hidden', true);
                    $('#lblAtivo').attr('hidden', true);
                });

            });
        }
    });

    jQuery.fn.extend({
        pesquisa_serversideSel: function (arr_txtCod, data_url, caption, callback) {
            let t = this;
            const modalId = `pesquisaModal_${$(t).attr('id') || Date.now()}`;
            let registrosSelecionados = [];
            let lista = [];

            $(t).unbind('pesquisou');
            $(t).on('pesquisou', function () {
                if (callback != undefined) {
                    callback();
                }
            });

            $(t).unbind('click');
            $(t).click(async function () {
                lista = $(arr_txtCod).val().length > 0 ? ajustaListaOptions($(arr_txtCod)[0].options) : [];
                registrosSelecionados = [];

                $("#pesquisaModalLabel").text(await traduzSentenca('Pesquisa de ') + await traduzSentenca(caption.toLowerCase().replace('pesquisa de ', '').replace('pesquisa ', '')));
                $("#pesquisaModal").modal("show");
                $.LoadingOverlay("show");

                function ajustaListaOptions(listaOptions) {
                    const listaFormatada = [];
                    let option = {};

                    for (let i = 0; i < listaOptions.length; i++) {
                        if (listaOptions[i].selected) {
                            const text = listaOptions[i].text;
                            listaFormatada.push(
                                option = {
                                    id: listaOptions[i].value,
                                    text: text.substr(text.indexOf(']') + 4)
                                }
                            )
                        }
                    }
                    return listaFormatada;
                }

                function ajustaData_URL(data_url) {
                    const obj = JSON.parse(data_url);
                    if (data_url == '{}') { return obj; }
                    if (obj.camposWhereServerSide == undefined) {
                        obj.camposWhereServerSide = JSON.parse(data_url).camposSelect;
                    }
                    // obj.camposSelect.insert(0, `'' AS SEL`);
                    obj.camposSelect.unshift(`'' AS SEL`);
                    return JSON.stringify(obj)
                }

                function ajustaData_URL2(data_url) {
                    const obj = JSON.parse(data_url);
                    if (data_url == '{}') { return obj; }
                    if ((obj.camposSelectSubSelect[0]).toUpperCase() == 'SEL') {
                        obj.camposSelectSubSelect.shift();
                    }
                    // obj.camposSelectSubSelect.insert(0, `'' AS SEL`);
                    obj.camposSelectSubSelect.unshift(`'' AS SEL`);
                    return JSON.stringify(obj)

                }

                let camposTabela;

                if (JSON.parse(data_url).camposSelectSubSelect != undefined) {
                    camposTabela = `<th class="th-sm">SEL</th>`;
                    if (JSON.parse(data_url).camposSelectSubSelect[0] != `'' AS SEL`) {
                        for (let i = 0; i < JSON.parse(data_url).camposSelectSubSelect.length; i++) {
                            camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelectSubSelect[i]}</th>`
                        };
                        data_url = ajustaData_URL2(data_url);
                    } else {
                        for (let i = 1; i < JSON.parse(data_url).camposSelectSubSelect.length; i++) {
                            camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelectSubSelect[i]}</th>`
                        };
                    }
                } else {
                    if (JSON.parse(data_url).camposSelect != undefined) {

                        camposTabela = `<th class="th-sm">SEL</th>`;
                        if (JSON.parse(data_url).camposSelect[0] != `'' AS SEL`) {
                            for (let i = 0; i < JSON.parse(data_url).camposSelect.length; i++) {
                                camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelect[i]}</th>`
                            };
                            data_url = ajustaData_URL(data_url);
                        } else {
                            for (let i = 1; i < JSON.parse(data_url).camposSelect.length; i++) {
                                camposTabela += `<th class="th-sm">${JSON.parse(data_url).camposSelect[i]}</th>`
                            };
                        }
                    } else {
                        camposTabela = `<th class="th-sm">SEL</th>`;
                        camposTabela += `<th class="th-sm">TELA</th>`;

                    }
                }

                let jsonPesquisa = JSON.parse(data_url);
                if (!jsonPesquisa.where) {
                    jsonPesquisa.where = [];
                }
                if (jsonPesquisa.tabela === 'PRODUTO' && $('#checkSomenteProdutos').is(':checked')) {
                    jsonPesquisa.where.push(`EXISTS (SELECT BLOQ_PRODPED FROM [SITPROD] SITPROD WHERE PRODUTO.STATUS = SITPROD.CODIGO AND SITPROD.BLOQ_PRODPED <> 'S')`)
                    data_url = JSON.stringify(jsonPesquisa);
                } else if (jsonPesquisa.where[0]) {
                    jsonPesquisa.where = jsonPesquisa.where.filter(condicao => !condicao.includes("EXISTS (SELECT BLOQ_PRODPED FROM [SITPROD]"))
                    data_url = JSON.stringify(jsonPesquisa);
                }

                if (jsonPesquisa.tabela == 'ENTIDADE') {
                    const apenasClientesVinculadosAoRepresentante = (await verificaParametroRepresentanteUsuario()) && (retornaRepresentanteUsuario() != '');
                    const isMaster = await uMasterOuSupervisor();
                    if ((apenasClientesVinculadosAoRepresentante) && (!isMaster)) {
                        jsonPesquisa = {
                            ...jsonPesquisa,
                            where: [...jsonPesquisa.where, `CODREP ='${retornaRepresentanteUsuario()}'`]
                        }
                        data_url = JSON.stringify(jsonPesquisa);
                    }
                }

                if (jsonPesquisa.tabela == 'REGIAO') {
                    const existeEmpValor = await fazSelectNaEmpValor('', 'REGIAO')
                    if (existeEmpValor.length > 0) {
                        jsonPesquisa = {
                            ...jsonPesquisa,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${'REGIAO'}' AND EMP_VALOR.VALOR = ${('REGIAO' + '.' + 'REGIAO')} AND EMP_VALOR.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`
                            }],
                            where: [`EMP_VALOR.EMP_ID ='${getCookie('g_emp_id_empresa_logada')}'`]
                        }
                    }
                    data_url = JSON.stringify(jsonPesquisa);
                }

                if (jsonPesquisa.tabela == 'CLASSE_GER') {
                    const existeEmpValor = await existeValorEmpValor('CLASSE_GER')
                    if (existeEmpValor) {
                        jsonPesquisa = {
                            ...jsonPesquisa,
                            innerjoin: [{
                                "tabela": "EMP_VALOR",
                                "condicao": `EMP_VALOR.TABELA = '${'CLASSE_GER'}' AND EMP_VALOR.VALOR = ${('CLASSE_GER' + '.' + 'CODIGO')} AND EMP_VALOR.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`
                            }],
                            where: [`EMP_VALOR.EMP_ID ='${getCookie('g_emp_id_empresa_logada')}'`]
                        }
                    }
                    data_url = JSON.stringify(jsonPesquisa);
                }
                if (data_url == '{}') {
                    $('#txtTabelaPesquisa').val('');
                } else {
                    $('#txtTabelaPesquisa').val(JSON.parse(data_url).tabela.toUpperCase());
                }
                validaBotaoRedirecionar();
                try {
                    const protocolo = getCookie('protocolo');

                    if ($('#checkSomenteProdutos').length === 0) {
                        $("#pesquisaModalBody").html(`<div class="col-sm-12 icheck-primary d-inline">` +
                            `<input class="form-check-input" type="checkbox" id="checkSelecionarTodos">` +
                            `<label class="form-check-label" for="checkSelecionarTodos">${getCookie('idiomaUsuario') == 'I' ? 'Select All' : getCookie('idiomaUsuario') == 'E' ? 'Seleccionar Todos' : getCookie('idiomaUsuario') == 'M' ? '選擇全部' : 'Selecionar Todos'}</label>` +
                            `</div>`);

                        if (jsonPesquisa.tabela === 'PRODUTO') {
                            $("#pesquisaModalBody").append(`<div class="col-sm-12 icheck-primary d-inline" title="Com essa opção ativa, valida o flag 'Bloq. Produto' da tela de Cadastro de Status, serve para desconsiderar Sub-Produtos.">` +
                                `<input class="form-check-input" type="checkbox" id="checkSomenteProdutos">` +
                                `<label class="form-check-label" for="checkSomenteProdutos">Somente Produtos</label>` +
                                `</div>`);
                        }
                        $("#pesquisaModalBody").append(`<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="pesquisaModalTable" ><thead><tr>${camposTabela}</tr></thead><tbody></tbody></table>`);
                    }

                    function retornaTabela() {
                        const urlPesquisa = data_url == '{}' ? `${protocolo}://${getCookie('ip_api')}/sisplan/acessomenu/v1/telas?` : `${protocolo}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`;

                        return new Promise((resolve, reject) => {
                            setTimeout(() => {
                                var table = $('#pesquisaModalTable').dataTable({
                                    destroy: true,
                                    lengthChange: false,
                                    autoWidth: true,
                                    serverSide: true,
                                    processing: true,
                                    timeout: 100000000,
                                    ajax: {
                                        url: urlPesquisa,
                                        type: "GET",
                                        headers: { 'Authorization': BASIC_AUTH },
                                        data: (d) => {
                                            d.EMPRESA = getCookie('empresa'),
                                                d.USUARIO = getCookie('usuario').toUpperCase(),
                                                d.JSON = data_url,
                                                d.CLIENTE = caption == 'Pesquisa Cliente' ? 'S' : 'N',
                                                d.TIPO_PESQUISA = $(`#selectPesquisa`).val() ?? ''
                                        }
                                    },
                                    rowId: 'extn',
                                    columnDefs: [
                                        {
                                            render(data, type, row, meta) {
                                                return `<div class="icheck-primary d-inline">
                                              <input type="checkbox" id="check${meta.row}_${modalId}" class="campoSel_${modalId}">
                                              <label for="check${meta.row}_${modalId}"></label>
                                            </div>`;
                                            },
                                            targets: [0],
                                        },
                                        {
                                            className: 'fixed-width',
                                            targets: 0,
                                        },
                                    ],
                                });
                                resolve(table); // Resolve a Promise com o valor da variável 'table'
                            }, 500);
                        });
                    }

                    retornaTabela().then((table) => {  // Chamada da função e utilização do valor exportado, aqui você tem acesso à variável 'table' exportada
                        // setTimeout(() => {
                        //     $("input[type='search']").focus();
                        // }, 500);

                        table.api().on('click', `.campoSel_${modalId}`, async function () {
                            const dados = table.api().rows($(this).closest('tr').index()).data().toArray();
                            if (!$(this).prop('checked')) {
                                registrosSelecionados = registrosSelecionados.filter(cod => (cod[1] != dados[0][1]));
                                $($(this).closest('tr')).removeClass('selected');
                            } else {
                                const indexJaExistente = registrosSelecionados.findIndex(index => dados[0][0] == index[0] && dados[0][1] == index[1] && dados[0][2] == index[2])
                                if (indexJaExistente == '-1') {
                                    registrosSelecionados.push(dados[0]);
                                }
                                $($(this).closest('tr')).addClass('selected');
                            }
                        });

                        $('#checkSelecionarTodos').on('change', async function () {
                            async function callBack() {
                                const sleepTime = $("#pesquisaModalTable_filter input").val() != '' ? 750 : 250;
                                $.LoadingOverlay("show");
                                try {
                                    $("#pesquisaModalTable").DataTable().page.len(200).draw(false);
                                    $($(".page-link")[1]).trigger("click");
                                    await sleep(sleepTime);
                                    const totalPaginas = $("#pesquisaModalTable").DataTable().page.info().pages;
                                    const considerar = $("#checkSelecionarTodos").prop("checked");

                                    for (let i = 1; i <= totalPaginas; i++) {
                                        if (considerar) {
                                            $(`.campoSel_${modalId}:not(:checked)`).trigger("click");
                                        } else {
                                            $(`.campoSel_${modalId}:checked`).trigger("click");
                                        }
                                        $("#pesquisaModalTable_next").trigger("click");
                                        await sleep(sleepTime);
                                        if (totalPaginas == i) {
                                            $($(".page-link")[1]).trigger("click");
                                            $("#pesquisaModalTable").DataTable().page.len(10).draw(false);
                                        }
                                    };
                                } finally {
                                    $.LoadingOverlay("hide");
                                }
                            }

                            msgAlerta(`Tem certeza que deseja ${!$("#checkSelecionarTodos").prop("checked") ? "desconsiderar" : "selecionar"} todos os registros? \nEssa ação percorrerá todas as páginas da tabela e resultará na seleção completa dos registros.`,
                                callBack,
                                () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
                                undefined,
                                () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
                                true);
                        });

                        $('#checkSomenteProdutos').off('change')
                        $('#checkSomenteProdutos').on('change', function () {
                            $(t).trigger('click');
                        })

                        $('#pesquisaModalTable').on('draw.dt', function () {
                            const dados = table.api().rows().data().toArray();
                            if (registrosSelecionados.length > 0) {
                                for (let j = 0; j < registrosSelecionados.length; j++) {
                                    for (let i = 0; i < dados.length; i++) {
                                        if (registrosSelecionados[j][1] == dados[i][1]) {
                                            $($(`.campoSel_${modalId}`)[i]).prop('checked', true);
                                            $($(`.campoSel_${modalId}`)[i].closest('tr')).addClass('selected');
                                        }
                                    }
                                }
                            }
                            if (lista.length > 0) {
                                for (let j = lista.length - 1; j >= 0; j--) {
                                    for (let i = 0; i < dados.length; i++) {
                                        if (lista[j].id == dados[i][1]) {
                                            $($(`.campoSel_${modalId}`)[i]).trigger('click');
                                            lista = lista.filter(cod => (cod.id != dados[i][1]));
                                            break;
                                        }
                                    }
                                }
                            }
                        });

                        $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('d-flex');
                        $('#pesquisaModalTable_wrapper .row > div').eq(1).addClass('justify-content-end');
                        $('#pesquisaModalTable_wrapper .row > div').eq(1).prepend(`
                                    <label style="display: flex;align-items: stretch;justify-content: flex-end;flex-direction: column;margin-right: 10px;">Tipo Pesquisa
                                    <select class="input-default" name="selectPesquisa" id="selectPesquisa" style="
                                        height: 30px;
                                        max-width: 230px;">
                                <option value="0">Iniciando</option>
                                <option value="1" selected>Contendo a(s) Palavra(s)</option>
                                <option value="2">Contendo a Expressão</option>
                                <option value="3">Igual</option>
                        </select>
                        </label>`)
                    });

                    $("#pesquisaModalSelecionar").unbind('click');
                    $("#pesquisaModalSelecionar").click(function () {
                        const listaNova = [];
                        const listaAnterior = [];
                        $.LoadingOverlay('show');
                        try {
                            let data = registrosSelecionados;

                            if (data.length > 0 || lista.length > 0) {
                                $(arr_txtCod).empty().trigger('change');
                                for (let i = 0; i < data.length; i++) {
                                    const option = {
                                        id: data[i][1].toString(),
                                        text: `[${data[i][1]}] - ${data[i][2]}`
                                    }
                                    const newOption = new Option(option.text, option.id, true, true);
                                    listaNova.push(newOption);
                                };

                                $(arr_txtCod).append(listaNova).trigger('change');

                                for (let i = 0; i < lista.length; i++) {
                                    const newOption = new Option(`[${lista[i].id}] - ${lista[i].text}`, lista[i].id, true, true);
                                    listaAnterior.push(newOption);
                                };

                                $(arr_txtCod).append(listaAnterior).trigger('change');

                            } else if (data.length == 0 && lista.length == 0) {
                                $(arr_txtCod).empty().trigger('change');
                            }
                            $(t).trigger('pesquisou');
                        } finally {
                            $.LoadingOverlay('hide');
                            $("#pesquisaModal").modal("hide");
                        }
                    });

                } catch (error) {
                    console.log(error)
                    $.LoadingOverlay("hide");
                    msgErro('Erro ao consultar dados, verifique a conexão.');
                    $("#pesquisaModal").modal("hide");
                }

                $.LoadingOverlay("hide");
                $("#pesquisaModalSelecionar").show();
                $("#pesquisaModalConfirmar").hide();
                $("#pesquisaModal").unbind('hidden.bs.modal');
                $('#pesquisaModal').on('hidden.bs.modal', function (_) {
                    $('#pesquisaModalBody').empty();
                    $(arr_txtCod).focus();
                    //PASSADO SetTimeout PARA QUANDO FECHAR O MODAL DE PESQUISA O COMPONENTE RECEBER NOVAMENTE O PLACEHOLDER E PARA DAR UM TRIGGER PARA MANTER SELECIONADO O DROPDOWN COM AS INFOEMAÇÕES
                    setTimeout(() => {
                        $(`.select2-search__field`).attr('placeholder', $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']);
                        $(arr_txtCod).parent().find(".select2-search__field").trigger('click');
                    }, 0);
                });
                $(`.${arr_txtCod[0].id}`).trigger('click');
            });
            //!!!!!!!CASO ALGUEM MEXER, FOI SETADO PARA DAR TRIGGER CLICK DUAS VEZES DE PROPÓSITO PARA NÃO BUGAR O SEARCH DO COMPONENTE!!!!!!!!!
            setTimeout(() => {
                $(arr_txtCod).parent().find(".select2-search__field").trigger('click');
                $(arr_txtCod).parent().find(".select2-search__field").trigger('click');
            }, 0);
        }
    });

    // $(function () {
    //     $('[data-toggle="tooltip"]').tooltip()
    // })

    // $('#btnFiltrosTour, #btnFiltros, #btn-filtros').attr('data-toggle', 'tooltip');
    // $('#btnFiltrosTour, #btnFiltros, #btn-filtros').attr('data-placement', 'top');
    // $('#btnFiltrosTour, #btnFiltros, #btn-filtros').attr('title', 'ALT + F');
    
    // ATALHOS
    $("body").keydown(function (e) {
        // ALT + F
        if (e.which === 70 && e.altKey) {
            e.preventDefault();
            if (($('.show').data('bs.modal') || {})._isShown != true) {
                $('#modal-filtros').modal('show');
                $('.modal-body input:text:visible:first').focus();
            }
            $('#btn-sair').trigger('click');
        }
        // ALT + S
        if (e.which === 83 && e.altKey) {
            e.preventDefault();
            $('#btn-msg-alerta').trigger('click');
            $('#btn-confirmarduplicata').trigger('click'); // modal duplicatas em aberto
        }
        // ALT + N
        if (e.which === 78 && e.altKey) {
            e.preventDefault();
            $('#btn-msg-cancelar').trigger('click');
        }
        // ALT + I
        if (e.which === 73 && e.altKey) {
            e.preventDefault();
            $('#btn-novoClientes, #btnNovaMoeda, #btnGravar, #btnNovaSped, #btnNovoProduto, #btnNovoPreco, #btnNovaRegiao, #btnNovoDeposito, #btn-novoPagar, #btn-novoReceber').trigger('click');
        }
        // CTRL + J
        if (e.ctrlKey && e.key.toUpperCase() === 'J') {
            e.preventDefault();
        }

        if ($("#modal-warning").attr("atalhosConfirmar") == 'true') {
            if (e.which == 13 || e.which == 9 || e.which == 32) {
                e.preventDefault();
                $('#btn-msg-alerta').trigger('click');
            }
        } else {
            //FEITO ISTO PARA CASO O MODAL ESTIVER ABERTO E CLICAR ENTER, ELE SEMPRE DAR O CLICK NO CANCELAR, PARA EVITAR DE PERDER INFORMAÇÕES.
            if (e.which === 13) {
                if (($('#modal-warning').data('bs.modal') || {})._isShown == true) {
                    e.preventDefault();
                    $('#btn-msg-cancelar').click();
                }
            }
        }
    });

    $('#txtSenhaSupervisor').keydown(function (e) {
        if (e.which === 13) {
            e.preventDefault();
            $('#btn-supervisor-confirmar').focus();
        }
    });

    $('#btnAbrirCadastro').unbind('click')
    $('#btnAbrirCadastro').on('click', function () {
        const tela = retornaNomeTela($('#txtTabelaPesquisa').val());
        if (tela == '') {
            return;
        }
        if (tela.tela == 'SIMBOLOGIA') {
            parent.abrirEmNovaAbaIFrame(tela.nome, `${BASE_URI}/v2/${tela.tela.toLowerCase()}`);
        } else {
            parent.abrirEmNovaAbaIFrame(tela.nome, `${BASE_URI}/${tela.tela.toLowerCase()}`);
        }
    });

    function retornaNomeTela(sTabela) {
        const tela = arrTelasTabela.find((tTela) => tTela.tabela == sTabela);
        return tela ? tela : ''
    }

    function validaBotaoRedirecionar() {
        const tela = arrTelasTabela.find((tTela) => tTela.tabela == $('#txtTabelaPesquisa').val());
        if (!tela) {
            $('#btnAbrirCadastro').addClass('d-none');
        } else {
            $('#btnAbrirCadastro').removeClass('d-none');
        }
    }

    const arrTelasTabela = [
        { tabela: 'ENTIDADE', tela: 'CLIENTE', nome: 'Cliente' },
        { tabela: 'CEP', tela: 'CEP', nome: 'Cep' },
        { tabela: 'MOEDA', tela: 'MOEDA', nome: 'Moeda' },
        { tabela: 'UNIDADE', tela: 'UNIDADE', nome: 'Unidade' },
        { tabela: 'TABTAM', tela: 'TAMANHO', nome: 'Tamanho' },
        { tabela: 'CADCOR', tela: 'COR', nome: 'Cor' },
        { tabela: 'GRUPOPA', tela: 'GRUPO', nome: 'Grupo' },
        { tabela: 'TABPIS', tela: 'CSTPIS', nome: 'CST PIS' },
        { tabela: 'TABCOFINS', tela: 'CSTCOFINS', nome: 'CST COFINS' },
        { tabela: 'ENQUADRA', tela: 'ENQUADRA', nome: 'Enquadra' },
        { tabela: 'TABLIN', tela: 'LINHA', nome: 'Linha' },
        { tabela: 'MARCA', tela: 'MARCA', nome: 'Marca' },
        { tabela: 'COLECAO', tela: 'COLECAO', nome: 'Coleção' },
        { tabela: 'GRUPO_COR', tela: 'GRUPOCOR', nome: 'Grupo de Cor' },
        { tabela: 'REGRA_FISCAL', tela: 'REGRAFISCAL', nome: 'Regra Fiscal' },
        { tabela: 'OPER_FISCAL', tela: 'OPERACAOFISCAL', nome: 'Operação Fiscal' },
        { tabela: 'FAIXA', tela: 'FAIXATAMANHO', nome: 'Faixa de Tamanho' },
        { tabela: 'REGIAO', tela: 'TABELADEPRECO', nome: 'Tabela de Preço' },
        { tabela: 'PRODUTO', tela: 'PRODUTO', nome: 'Produto' },
        { tabela: 'TABTRAN', tela: 'TRANSPORTADORA', nome: 'Transportadora' },
        { tabela: 'REPRESEN', tela: 'REPRESENTANTE', nome: 'Representante' },
        { tabela: 'TABSPED', tela: 'SPED', nome: 'Sped' },
        { tabela: 'TABFIS', tela: 'CLAFISCAL', nome: 'Classificação Fiscal' },
        { tabela: 'TABTRI', tela: 'CLATRIB', nome: 'Classificação Tributária' },
        { tabela: 'TABCSOSN', tela: 'CSOSN', nome: 'CSOSN' },
        { tabela: 'TABIPI', tela: 'CSTIPI', nome: 'CST IPI' },
        { tabela: 'DEPOSITO', tela: 'DEPOSITO', nome: 'Depósito' },
        { tabela: 'ETQ_PROD', tela: 'ETIQUETA', nome: 'Etiqueta' },
        { tabela: 'NATUREZA', tela: 'NATUREZA', nome: 'Natureza' },
        { tabela: 'REGRA', tela: 'REGRA', nome: 'Regra' },
        { tabela: 'SITPROD', tela: 'SITUACAO', nome: 'Situação' },
        { tabela: 'MAQUINA_CARTAO', tela: 'MAQUINACARTAO', nome: 'Máquina de Cartão' },
        { tabela: 'ACESSO_USUARIOS', tela: 'USUARIO', nome: 'Usuário' },
        { tabela: 'REGRA_PROMOCAO', tela: 'REGRAPROMOCAO', nome: 'Regra de Promoção' },
        { tabela: 'CAIXA_LOJA', tela: 'CADCAIXA', nome: 'Cadastro de Caixa' },
        { tabela: 'PRECO_COR_TAM', tela: 'PRECOCORTAM', nome: 'Preco por Cor/Tamanho' },
        { tabela: 'VENDA_CAIXA', tela: 'VENDEDORCAIXA', nome: 'Vendedor Caixa' },
        { tabela: 'TABSIT', tela: 'SITUACAODUPLICATA', nome: 'Situação da Duplicata' },
        { tabela: 'CONDICAO', tela: 'CONDICAOPAGAMENTO', nome: 'Condição de Pagamento' },
        { tabela: 'CADCONTA', tela: 'CADCONTA', nome: 'Cadastro de Conta' },
        { tabela: 'CLASSE_GER', tela: 'CLASSEGERENCIAL', nome: 'Classe Gerencial' },
        { tabela: 'CADBAN', tela: 'CADBANCO', nome: 'Cadastro de Banco' },
        { tabela: 'MATERIAL', tela: 'MATERIAL', nome: 'Material' },
        { tabela: 'GRUPO_MA', tela: 'GRUPOMATERIAL', nome: 'Grupo de Material' },
        { tabela: 'SUBGRUPO_MA', tela: 'SUBGRUPOMA', nome: 'Subgrupo de Material' },
        { tabela: 'EMPRESA', tela: 'EMPRESA', nome: 'Empresa' },
        { tabela: 'TABPRZ', tela: 'CADPRAZO', nome: 'Cadastro de Prazo' },
        { tabela: 'TIPO_APL', tela: 'CADPARTE', nome: 'Cadastro de Parte' },
        { tabela: 'CADFLUXO', tela: 'CADSETOR', nome: 'Cadastro de Setor' },
        { tabela: 'TEF_OPERADORA', tela: 'OPERADORATEF', nome: 'Informações do TEF' },
        { tabela: 'FATCONF_XML', tela: 'CONFIMPRESSAO', nome: 'Confimpressao' },
        { tabela: 'GRUPO_PA', tela: 'GRUPO', nome: 'Grupo' },
        { tabela: 'SITPROD', tela: 'SITUACAO', nome: 'Situação' },
        { tabela: 'SIMBOLOGIA', tela: 'SIMBOLOGIA', nome: 'Simbologia' },
        { tabela: 'HISTCP', tela: 'CADHISTORICO', nome: 'Cadastro de Histórico' },
        { tabela: 'TABBAI', tela: 'TIPOBAIXA', nome: 'Tipo de Baixa' },
        { tabela: 'TABQUL', tela: 'QUALIDADE', nome: 'Qualidade' },
        { tabela: 'ROTEIRO', tela: 'FLUXO', nome: 'Fluxo' },
        { tabela: 'MODELO', tela: 'MODELO', nome: 'Modelo' },
        { tabela: 'TIPO', tela: 'TIPO', nome: 'Tipo' },
        { tabela: 'PEDIDO', tela: 'PEDIDO', nome: 'Pedido' },
        { tabela: 'PESSOAL', tela: 'FUNCIONARIO', nome: 'Funcionário' },
        { tabela: 'CADCOMPOSI', tela: 'COMPOSICAOPRODUTO', nome: 'Composição do Produto' },
        { tabela: 'TABUF', tela: 'UF', nome: 'Uf' },
        { tabela: 'GRUPO_CLI', tela: 'GRUPOCLIENTE', nome: 'Grupo de Cliente' },
        { tabela: 'CAD_TIPO_PROD', tela: 'TIPOPRODUTO', nome: 'Tipo de Produto' },
        { tabela: 'CONTATO', tela: 'CLIENTE', nome: 'Cliente' },
        { tabela: 'CLASSE_COR', tela: 'CLASSECOR', nome: 'Classe de Cor' },
        { tabela: 'MENSAGEM', tela: 'MOTIVO', nome: 'Motivo' },
        { tabela: 'CENTROCUSTO', tela: 'CENTROCUSTO', nome: 'Centro de Custo' },
        { tabela: 'COMPRA', tela: 'LIBERACAO_OC', nome: 'Liberação O.C' },
        { tabela: 'TABTAM', tela: 'TAMAHNO', nome: 'Tamanho' },
        { tabela: 'SERVICO', tela: 'CADSERVICO', nome: 'Cadastro de Serviço' },
        { tabela: 'GRUPO_PED', tela: 'GRUPOPED', nome: 'Grupo de Pedido' },
        { tabela: 'VENDA_TIPO', tela: 'TIPOVENDA', nome: 'Tipo de Venda' },
        { tabela: 'OBRA', tela: 'CADOBRA', nome: 'Cadastro de Obra' },
        { tabela: 'AUXILIAR', tela: 'AUXILIAR', nome: 'Cadastro Auxiliar' },
        { tabela: 'SUBGRUPO_COR', tela: 'SUBGRUPOCOR', nome: 'Subgrupo de Cor' },
        { tabela: 'CIDADE', tela: 'CADCIDADE', nome: 'Cidade' },
        { tabela: 'REG_ESTADO', tela: 'CADREGESTADO', nome: 'Região de Estado' },
        { tabela: 'SITCLI', tela: 'RAMOATIVIDADE', nome: 'Ramo Atividade' },
        { tabela: 'PERFIL', tela: 'PERFIL', nome: 'Perfil' },
        { tabela: 'CADCEP', tela: 'CEP', nome: 'CEP' },
        { tabela: 'CADPAIS', tela: 'PAIS', nome: 'País' },
        { tabela: 'CILINDRO', tela: 'CILINDRO', nome: 'Cilindro' },
        { tabela: 'CARACTERISTICA', tela: 'SUBCARACTERISTICA', nome: 'Sub Caracteristica' },
        { tabela: 'PCPAPL', tela: 'APLICACAO_PCP', nome: 'Aplicação de PCP' },
        { tabela: 'COMPOSICAO_MAT', tela: 'COMPOSICAOMATERIAL', nome: 'Composição de Material' },
        { tabela: 'ESPECIE', tela: 'ESPECIE', nome: 'Cadastro de Espécie' },
        { tabela: 'FUNCAO', tela: 'FUNCAO', nome: 'Cadastro de Função' },
        { tabela: 'MEDIDAS', tela: 'MEDIDAS', nome: 'Cadastro de Medidas' },
        { tabela: 'ENTID_AUX', tela: 'ENTIDADE_AUX', nome: 'Entidade Auxiliar' },
    ];

    // --/--/--/--/--/--/--/--/--/--/--/--
    if ($('div').hasClass("listaBotoes") && $('.listaBotoes').attr('class').includes("ajustaBotao")) {
        if ($('.listaBotoes').attr('class').includes("[") && $('.listaBotoes').attr('class').includes("]")) {

            let o = null;
            if ($('.listaBotoes > button').hasClass("marginBtnH")) {
                o = "H";
            } else if ($('.listaBotoes > button').hasClass("marginBtnV")) {
                o = "V";
            }

            if (o === "H" || o === "V") {
                let zoomPage = 0;
                let zoomSistema = null;

                function pegaArrayBotoes() {
                    const listaAjustar = $('.listaBotoes').first().attr('class').split('[')[1];
                    const botoesPAjustar = listaAjustar.toLowerCase().replace(']', '').replaceAll('ú', 'u').replaceAll("ultimo", `"ultimo"`);
                    const stringBotoes = `[${botoesPAjustar}]`;
                    const arrayBotoes = JSON.parse(stringBotoes.toLowerCase());

                    if (arrayBotoes.length === 0) {
                        console.error(`Necessário informar um valor no array da classe "ajustaBotao[]"`);
                    };

                    return arrayBotoes;
                };

                function verificarZoom() {
                    const zoomCSS = parseFloat($("body").css("zoom")) * 100 || 90;
                    zoomPage = window.devicePixelRatio * 100 || Math.round(zoomCSS);
                    zoomSistema = parseInt(localStorage.getItem("zoom"));

                    const arrayBotoes = pegaArrayBotoes()

                    for (i = 0; i < arrayBotoes.length; i++) {
                        aplicarClasseNoBotao(arrayBotoes[i] + 1);
                    };
                };

                function aplicarClasseNoBotao(botao) {
                    const ultimo = botao.toString().toLowerCase() === 'ultimo1';
                    const sel = ultimo ? "last-child" : `nth-child(${botao})`

                    if (Math.round(zoomPage) === Math.round(zoomSistema)) {
                        $(`.listaBotoes > .marginBtn${o}:${sel}`).removeClass(`marginBtn${o}`).addClass(`marginBtn${o}-MarginMenor`);
                    } else {
                        $(`.listaBotoes > .marginBtn${o}-MarginMenor:${sel}`).removeClass(`marginBtn${o}-MarginMenor`).addClass(`marginBtn${o}`);
                    };
                };

                verificarZoom();
                window.addEventListener('resize', verificarZoom);
            } else {
                console.error(`Necessário informar a orientação da margem no seguinte padrão:
                    \n "marginBtnH" para margem na horizontal (margin-left: 2.5px) 
                    \n "marginBtnV" para magem na vertical (margin-bottom: 2.5px)`);
            }
        } else {
            console.error(`Necessário informar a classe "ajustaBotao${o}" com um array de valores: ajustaBotao${o}[1,2,3,4].`);
        };
    };
    // --/--/--/--/--/--/--/--/--/--/--/--
    if ($("button").hasClass("btnTutorial")) {
        $(".btnTutorial").prop("title", "Clique para abrir o tutorial");
    };
})
