$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CADCUPOMDESCONTO");


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  consultaCupons();

  $("#btn-filtros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $('#btnConsultar').trigger('click');


  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaCupons(true);
  });

  $('#btnNovoCupom').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cadcupomdesconto/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('CADCUPOMDESCONTO', getCookie('usuario'), parametros[parametros.length - 1]);
    window.location.href = `${BASE_URI}/cadcupomdesconto`;
  });

  $('#btn-limpa-codigo').on('click', function () {
    $('#txtCodigo').val('');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtCodigo').val('');
    $('#dtInicio').val('1200-01-01');
    $('#dtFim').val('2500-12-31');
  });

  $('#btn-codigo-filtro').pesquisa_serverside(['#txtCodigo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CUPOMDESCONTO", "camposSelect":[ "CODIGO", "DESCRICAO", "DT_INICIO", "DT_FINAL"], "where": null}', 'Pesquisa Cupom');
  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"CUPOMDESCONTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  componenteFiltro('cliente', true);

  async function consultaCupons(bBotao = false) {
    try {
      $.LoadingOverlay("show");

      const dtInicio = $('#dtInicio').val();
      const dtFim = $('#dtFim').val();
      const cupomCodigo = pegaChave('#txtCodigo');
      const clientes = await formataListas($('#txtCliente').val().toString())
      const pendente = $('#rdStatusPendentes').is(':checked')
      const utilizado = $('#rdStatusUtilizados').is(':checked')

      const camposSelect = [
        "CUPOMDESCONTO.CODIGO",
        "CUPOMDESCONTO.DESCRICAO",
        "CUPOMDESCONTO.CODCLI",
        "ENTIDADE.NOME",
        "COALESCE(PERC_DESC,0) PERC_DESC",
        "COALESCE(VALOR,0) VALOR_DESC",
        "CUPOMDESCONTO.DT_INICIO",
        "CUPOMDESCONTO.DT_FINAL",
        "CUPOMDESCONTO.QUANTIDADE",
        "(SELECT COUNT(*) FROM [VENDA] VENDA WHERE VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO) QUANTIDADE_UTILIZADA"
      ];

      const leftJoin = [{
        tabela: "ENTIDADE",
        condicao: "CUPOMDESCONTO.CODCLI = ENTIDADE.CODCLI"
      }];

      const criaPesquisa = (dtInicio, dtFim, cupomCodigo, clientes, pendente = false, utilizado = false) => {
        let adicionaWhere = null;
        if (bBotao) {
          adicionaWhere = [`(CUPOMDESCONTO.DT_INICIO >= '${dtInicio}' AND CUPOMDESCONTO.DT_FINAL <= '${dtFim}')`];
          if (cupomCodigo) {
            adicionaWhere.push(`CUPOMDESCONTO.CODIGO = '${cupomCodigo}'`);
          }
          if (clientes) {
            adicionaWhere.push(`CUPOMDESCONTO.CODCLI IN (${clientes})`);
          }
          if (pendente){
            adicionaWhere.push(`CUPOMDESCONTO.QUANTIDADE > (SELECT COUNT(*) FROM [VENDA] VENDA WHERE VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO)`);
          }
          if (utilizado){
            adicionaWhere.push(`CUPOMDESCONTO.QUANTIDADE <= (SELECT COUNT(*) FROM [VENDA] VENDA WHERE VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO)`);
          }
          adicionaWhere = [adicionaWhere.join(' AND ')];
        }

        return {
          tabela: "CUPOMDESCONTO",
          camposSelect,
          leftJoin,
          where: adicionaWhere,
          limit: !bBotao ? 10000 : undefined
        };
      };

      const query = criaPesquisa(dtInicio, dtFim, cupomCodigo, clientes, pendente, utilizado);

      const response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON=${JSON.stringify(query)}`,
        null
      );

      $.LoadingOverlay("hide");

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaCupom').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [{
          "data": "CODIGO",
          "title": "Código"
        },
        {
          "data": "DESCRICAO",
          "title": "Descrição"
        },
        {
          "data": "CODCLI",
          "title": "Cód. do Cliente"
        },
        {
          "data": "NOME",
          "title": "Nome do Cliente"
        },
        {
          "data": "PERC_DESC",
          "title": "Percentual Desc."
        },
        {
          "data": "VALOR_DESC",
          "title": "Valor Desc."
        },
        {
          "data": "DT_INICIO",
          "title": "Data Início"
        },
        {
          "data": "DT_FINAL",
          "title": "Data Final"
        },
        {
          "data": "QUANTIDADE",
          "Title": "Quantidade"
        },
        {
          "data": "QUANTIDADE_UTILIZADA",
          "title": "Qtde. Utilizada"
        },
        ],
        "columnDefs": [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [4, 5],
            "className": 'pr-4 text-right'
          },
          {
            type: 'date-br',
            targets: [6, 7],
            render: function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          },
          {
            targets: [6, 7],
            "className": 'pr-4 text-right'
          }
        ]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaCupom').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaCupom').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('CADCUPOMDESCONTO', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `cadcupomdesconto/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCupom').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaCupom').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('CADCUPOMDESCONTO', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `cadcupomdesconto/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCupom').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCupom").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/cupomdesconto?", `CODIGO=${valorLinha.CODIGO}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelCupomDesconto')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/imprimircupomdesconto?`;

        const retornaFiltros = async () =>{
          const dtInicio = $('#dtInicio').val();
          const dtFim = $('#dtFim').val();
          const cupomCodigo = pegaChave('#txtCodigo');
          const clientes = await formataListas($('#txtCliente').val().toString())
          const pendente = $('#rdStatusPendentes').is(':checked')
          const utilizado = $('#rdStatusUtilizados').is(':checked')

          return `DTINICIO=${dtInicio}` +
                 `&DTFIM=${dtFim}` +
                 `&CODIGO=${cupomCodigo}` +
                 `&CLIENTES=${clientes}` +
                 `&STATUS=${pendente ? '1' : utilizado ? '2' : '0'}`
        }

        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelCupomDesconto');
        let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelCupomDesconto');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  function verificaClientesCupom() {
    let clientes = JSON.parse(localStorage.getItem('clientescupom')) ?? [];
    if (clientes.length > 0) {
      $('#btnNovoCupom').trigger('click');
    }
  }

  window.addEventListener('storage', function (event) {
    if (event.key == 'clientescupom') {
      verificaClientesCupom();
    }
  });

  verificaClientesCupom();
});