$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui você pode aplicar os filtros para gerar os resultados que deseja',
        position: 'bottom'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Impressão',
        description: 'Neste botão, você poderá imprimir um relatório sobre os dados gerados.',
        position: 'bottom'
      }
    },
    {
      element: '#tabelaComissao',
      popover: {
        title: 'Lista Representantes',
        description: 'Aqui é apresentado os representantes e seus valores de venda/comissão/meta.',
        position: 'top'
      }
    },
    {
      element: '#tabelaComissaoCoord',
      popover: {
        title: 'Lista Coordenadores',
        description: 'Aqui é apresentado os coordenadores e os valores gerados a partir das vendas de seus representantes.',
        position: 'top'
      }
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('#txtVendedor').pesquisa_variosServerside(1, '{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'CODREP', 'NOME');
  $('#txtCoordenador').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');

  $('#btnVendedor').pesquisa_serversideSel('#txtVendedor', `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}`, 'Pesquisa Vendedor');

  $('#btnCoordenador').pesquisa_serversideSel('#txtCoordenador', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa Coordenador');

  $("#btnLimpaVendedor").on("click", function () {
    $('#txtVendedor').empty().trigger('change');
  });

  $("#btnLimpaCoordenador").on("click", function () {
    $('#txtCoordenador').empty().trigger('change');
  });

  $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
  $('#txtConta').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
  $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
  $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
  $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
  $('#btn-Conta').pesquisa('#txtConta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta', 'cadconta');

  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });
  $('#btn-limpa-Fornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });
  $('#btn-limpa-Situacao').on('click', function () {
    $('#txtSituacao').val('');
  });
  $('#btn-limpa-Banco').on('click', function () {
    $('#txtBanco').val('');
  });
  $('#btn-limpa-Conta').on('click', function () {
    $('#txtConta').val('');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtVendedor').empty().trigger('change');
    $('#txtCoordenador').empty().trigger('change');
    $('#dtInicioDe').val('1200-01-01');
    $('#dtInicioAte').val('2500-12-31');
  });

  //Modais
  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  retornaHintRelatorio('btnImprimir', 'relFechamentoComissao')

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const url = `/sisplan/impressao/v1/imprimirfechamentocomissao?`;
        const Filtros = await preencheFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelFechamentoComissao');
        const arquivo = await GeraRelatorio(`${url}${Filtros}`, "GET", 100000, false, 'RelFechamentoComissao');

        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function preencheFiltros() {
    try {
      const dtInicioDe = $('#dtInicioDe').val() != '1200-01-01' ? `&DATA_DE=${$('#dtInicioDe').val()}` : '';
      const dtInicioAte = $('#dtInicioAte').val() != '2500-12-31' ? `&DATA_ATE=${$('#dtInicioAte').val()}` : '';
      const vendedores = $('#txtVendedor').val().length > 0 ? `&VENDEDORES=${await formataListas($('#txtVendedor').val().toString())}` : '';
      const coordenadores = $('#txtCoordenador').val().length > 0 ? `&COORDENADORES=${await formataListas($('#txtCoordenador').val().toString())}`.trim() : '';

      const filtrosTela = `TESTE=1${vendedores}${coordenadores}${dtInicioDe}${dtInicioAte}`;
      return filtrosTela;

    } catch (error) {
      console.error(error);
    }
  }

  async function limpaTabela() {
    $('#tabelaComissao').DataTable().destroy().draw(false);
    $('#tabelaComissao').html('<thead></thead><tbody></tbody>');
  }

  async function montaTabelaCoordenadores(coordenadores) {

    if ($.fn.DataTable.isDataTable('#tabelaComissaoCoord')) {
      $('#tabelaComissaoCoord').DataTable().destroy();
      $('#tabelaComissaoCoord').empty();
    };


    if ((!coordenadores) || (coordenadores.length == 0)) {
      return;
    }

    dadosCoordenadores = coordenadores.map(coord => { return { ...coord, DETALHES: '' } });
    const dataSetCols = [];
    const keys = Object.keys(coordenadores[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $("#tabelaComissaoCoord").DataTable({
      paging: false,
      filter: true,
      info: false,
      order: false,
      destroy: true,
      scrollX: '250px',
      scrollY: '290px',
      autoWidth: true,
      data: dadosCoordenadores,
      columns: dataSetCols,
      "columnDefs": [
        {
          targets: [6, 7],
          visible: false
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          "targets": [3, 4, 8],
          "className": 'pr-4 text-right'
        },
        {
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }) + ' %';
          },
          targets: [5],
          "className": 'pr-4 text-right'
        },
      ],
    });


    // $('.btnDetalhesCoord').o\\n('click', async function () {
    //   try {
    //     $.LoadingOverlay('show');
    //     const tr = this.closest('tr');
    //     const dados = $('#tabelaComissao').DataTable().row($(tr)).data();
    //     const codRep = dados.CODREP;
    //     const nomeRep = dados.NOME_REP;
    //     $('#modal-vendas .modal-title').html(`Vendas Representante - ${nomeRep}`);
    //     await buscaTabelaVendasRep(codRep);
    //     $('#modal-vendas').modal('show');
    //     $(`#tabelaVendasRep`).DataTable().columns.adjust().draw(false);
    //   } finally {
    //     $.LoadingOverlay('hide');
    //   }
    // });
  }

  function copyAndTransformKeysToUppercase(obj) {
    return Object.keys(obj).reduce((acc, key) => {
      acc[key.toUpperCase()] = obj[key];
      return acc;
    }, {});
  }

  async function buscaTabelaVendasRep(codrep) {
    const dataSetCols = [];
    if ($.fn.DataTable.isDataTable('#tabelaVendasRep')) {
      $('#tabelaVendasRep').DataTable().destroy();
      $('#tabelaVendasRep').empty();
    };

    try {
      const dataIni = "'" + $('#dtInicioDe').val() + "'";
      const dataFim = "'" + $('#dtInicioAte').val() + "'";

      const pesquisaVendas = {
        camposSelect: [],
        tabela: "venda",
        leftjoin: [{
          tabela: "entidade",
          condicao: "entidade.codcli = venda.codcli"
        },
        {
          tabela: "itvenda",
          condicao: "itvenda.codven = venda.codven and itvenda.emp_id = venda.emp_id"
        }
        ],
        groupby: [],
        orderby: ["venda.codven desc"],
        where: []
      }

      const separador = "' - '";
      const iEmpID = getCookie('emp_id');

      pesquisaVendas.camposSelect = pesquisaVendas.camposSelect.concat([
        "VENDA.CODVEN VENDA",
        `VENDA.CODCLI|| ${separador}||ENTIDADE.NOME CLIENTE`,
        `CASE WHEN (VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0) THEN 'Pendente'` +
        `WHEN ((SELECT CANCELADA FROM VENDA_001 WHERE CODVEN = VENDA.CDAGRUPADA) = 1) THEN 'CANCELADA'` +
        `WHEN (VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0) THEN 'AGRUPADA'` +
        `WHEN ((VENDA.CANCELADA = 1) AND ((VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S'))) THEN 'CANCELADA'` +
        `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0 OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S')) THEN 'Fechada'` +
        `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 0 AND (VENDA.TROCA = 1 OR VENDA.DEVOLUCAO = 1 AND VENDA.ORCAMENTO = 0)) THEN 'Devolucao/Troca'` +
        `ELSE 'Orcamento' END STATUS`,
        "VENDA.NRCAIXA",
        "VENDA.DATA",
        "VENDA.HR_VENDA",
        "CASE WHEN VENDA.DEVOLUCAO = 1 THEN -VENDA.VALOR ELSE VENDA.VALOR END VALOR",
        "SUM(CASE WHEN VENDA.DEVOLUCAO = 1 THEN -ITVENDA.QUANTIDADE ELSE ITVENDA.QUANTIDADE END) QTDE_ITENS"
      ]);

      pesquisaVendas.groupby = pesquisaVendas.groupby.concat([
        "VENDA.CODVEN",
        "VENDA.TIPO_VENDA",
        "VENDA.EMP_ID",
        "VENDA.CODCLI",
        "ENTIDADE.NOME",
        "VENDA.FECHADA",
        "VENDA.CANCELADA",
        "VENDA.ORCAMENTO",
        "VENDA.TROCA",
        "VENDA.CONSIG_FINALIZADO",
        "VENDA.DEVOLUCAO",
        "VENDA.IMPRESSO",
        "VENDA.NRCAIXA",
        "VENDA.CDAGRUPADA",
        "VENDA.DATA",
        "VENDA.HR_VENDA",
        "VENDA.VALOR",
        "VENDA.CODREP"
      ]);

      pesquisaVendas.where.push(`VENDA.CODREP = '${codrep}' AND VENDA.EMP_ID = ${iEmpID} AND (VENDA.FECHADA = 1 OR VENDA.DEVOLUCAO = 1) AND VENDA.CANCELADA = 0 AND (VENDA.DATA >= ${dataIni} AND VENDA.DATA <= ${dataFim})`);
      const empresa = getCookie('empresa');
      const url = `/sisplan/funcoes/v1/pesquisa?empresa=${empresa}&JSON=${JSON.stringify(pesquisaVendas)}`;


      const response = await requisicao(
        "GET",
        '',
        url,
        null,
        60000
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let dataSet = [];

      if (!jsonStr['RESULT'][0]) {
        dataSet.push(jsonStr['RESULT'][0]);
      } else {
        dataSet = jsonStr['RESULT'][0];
      }

      const keys = Object.keys(dataSet[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k.toUpperCase(),
          data: k.toUpperCase(),
        });
      });

      dataSetCols[2].render = function (data, type, row) {
        if (row["STATUS"] == 'PENDENTE') {
          return '<div class="d-flex"><i class="fas fa-circle text-green mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'AGRUPADA') {
          return '<div class="d-flex"><i class="fas fa-circle text-purple mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'CANCELADA') {
          return '<div class="d-flex"><i class="fas fa-circle text-red mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'FECHADA') {
          return '<div class="d-flex"><i class="fas fa-circle text-blue mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'DEVOLUCAO/TROCA') {
          return '<div class="d-flex"><i class="fas fa-circle text-yellow mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else {
          return '<div class="d-flex"><i class="fas fa-circle text-grey mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        }
      }

      dataSetCols[4].type = 'date-br';
      dataSetCols[4].render = function (data, type, row) {
        var isIE = function () {
          if (/MSIE/i['test'](navigator['userAgent']) == true || /Edge/i['test'](navigator[
            'userAgent']) == true) {
            return true;
          } else {
            return false;
          }
        }
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return x[2] + "/" + x[1] + "/" + x[0] + row['HR_VENDA'].slice('10');
        } else {
          x = data.slice(0, 10).split('-');
          return x[2] + "/" + x[1] + "/" + x[0] + row['HR_VENDA'].slice('10');
        }
      }

      $("#tabelaVendasRep").DataTable({
        paging: false,
        filter: true,
        info: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '290px',
        autoWidth: true,
        data: dataSet,
        columns: dataSetCols,
        "columnDefs": [
          {
            targets: [5],
            visible: false
          },
          {
            "targets": [7],
            "className": 'pr-4 text-right'
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [6],
            "className": 'pr-4 text-right'
          }
        ],
      });

    } catch (error) {
      console.log(error);
    }
    finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaTabelaComissao() {
    const dataSetCols = [];
    if ($('#tabelaComissao')[0].rows.length > 0) {
      await limpaTabela();
    }
    $('#divTabelaComissao').removeClass('d-none')
    if ($.fn.DataTable.isDataTable('#tabelaComissao')) {
      $('#tabelaComissao').DataTable().destroy();
      $('#tabelaComissao').empty();
    };

    try {

      const filtrosTela = await preencheFiltros();
      const url = `/sisplan/impressao/v1/consultafechamentocomissao?`;
      const response = await requisicao(
        "GET",
        url,
        filtrosTela,
        null,
        60000
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      const listaCoordenadores = jsonStr.comissaoCoordenador ? jsonStr.comissaoCoordenador.map(dado => copyAndTransformKeysToUppercase(dado))
        : [];
      await montaTabelaCoordenadores(listaCoordenadores);

      if (jsonStr.comissaoRepresentante.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtVendedor").val();
        $("#txtCoordenador").val();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }


      const retornoTratado = jsonStr.comissaoRepresentante.map(comissao => copyAndTransformKeysToUppercase(comissao));

      const dados = retornoTratado.map(rep => { return { ...rep, ACOES: '' } });
      const keys = Object.keys(retornoTratado[0]);


      dataSetCols.push({
        title: 'ACOES',
        data: 'ACOES',
      });

      keys.forEach((k) => {
        dataSetCols.push({
          title: k.toUpperCase(),
          data: k.toUpperCase(),
        });
      });


      $("#tabelaComissao").DataTable({
        paging: false,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '290px',
        // "pageLength": qtdeLinhasTabela,
        autoWidth: true,
        data: dados,
        columns: dataSetCols,
        "columnDefs": [
          {
            targets: [0],
            render: function (data, type, row) {
              return retornaBotoesAcao(data);
            }
          },
          {
            targets: [7, 8],
            visible: false
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            "targets": [4, 5, 9],
            "className": 'pr-4 text-right'
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }) + ' %';
            },
            targets: [6],
            "className": 'pr-4 text-right'
          },
        ],
      });

      $('.btnDetalhesRep').on('click', async function () {
        try {
          $.LoadingOverlay('show');
          const tr = this.closest('tr');
          const dados = $('#tabelaComissao').DataTable().row($(tr)).data();
          const codRep = dados.CODREP;
          const nomeRep = dados.NOME_REP;
          $('#modal-vendas .modal-title').html(`Vendas Representante - ${nomeRep}`);
          await buscaTabelaVendasRep(codRep);
          $('#modal-vendas').modal('show');
          $(`#tabelaVendasRep`).DataTable().columns.adjust().draw(false);
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      $('.btnGerarAP').on('click', async function () {
        try {
          $.LoadingOverlay('show')
          const tr = this.closest('tr')
          const dados = $('#tabelaComissao').DataTable().row($(tr)).data()
          await abreModalPagar(dados)
        } finally {
          $.LoadingOverlay('hide')
        }
      });


    } catch (error) {
      console.log(error);
    }
    finally {
      $.LoadingOverlay('hide')
    }
  }

  function retornaBotoesAcao(data) {
    return '<div class="divBtnOpcoes p-0" style="max-width: 120px"> ' +
      '     <button class="botaoOpcoes btn-sm btnGerarAP" type="button" title="Gerar AP" id="btnGerarAP"><span class="fas fa-file-invoice-dollar" style="color:white"></span></button>     ' +
      '     <button class="botaoOpcoes btn-sm btnDetalhesRep" type="button" title="Vendas Representante" id="btnDetalhesRep"><span class="fas fa-chart-bar" style="color:white"></span></button>  ' +
      '   </div>';
  };


  $("#btnConsultar").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        await buscaTabelaComissao();

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }
  });
  $("#btnFiltros").trigger('click');

  async function abreModalPagar(data) {
    const valorFormatado = new Intl.NumberFormat('pt-BR', {
      style: 'currency',
      currency: 'BRL'
    }).format(parseFloat(data.VAL_COMISSAO));

    const numAp = await validaPagar(`através do Fechamento de Comissão por Meta`, data.CODREP, data.VAL_COMISSAO)

    if (numAp) {
      msgAguardaConfirmacao(`Existe uma AP para o representante ${data.NOME_REP} com o valor: ${valorFormatado} gerado pelo Fechamento de Comissão. \nAP número: ${numAp}\n\rDeseja continuar?`, async () => await callBack())
    } else {
      await callBack()
    }

    async function callBack() {
      $.LoadingOverlay('show')
      try {
        $('#txtObs').val(`Comissão para o vendedor ${data.NOME_REP}, no valor de ${valorFormatado}, através do Fechamento de Comissão por Meta.`);

        insereValor('#txtValor', parseFloat(data.VAL_COMISSAO));
        setarDataAtual('txtDTemissao');
        let dtPagamento = await retornaDtPagamentoRep(data.CODREP);
        let hoje = new Date();
        hoje.setDate(dtPagamento);
        hoje.setMonth(hoje.getMonth() + 1);
        let ano = hoje.getFullYear();
        let mes = ('0' + (hoje.getMonth() + 1)).slice(-2);
        let dia = ('0' + hoje.getDate()).slice(-2);
        let dataFormatada = `${ano}-${mes}-${dia}`;
        $('#txtDTvencimento').val(dataFormatada);
        insereValor('#txtFornecedor', data.CODREP, data.NOME_REP)
        $('#txtStatus').val('DUPL');

        const proxDocto = await RetornaProximo('PAGTO', 'PAGTO', 'DOCTO', 6)

        $('#txtNotaFiscal').val(proxDocto)

        $('#modal-pagar').modal('show')
      } catch (error) {
        console.error(error)
        msgAlerta(error.message)
      } finally {
        $.LoadingOverlay('hide')
      }
    }
  }

  async function retornaDtPagamentoRep(codrep) {
    try {
      response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"REPRESEN", "camposSelect":["DIA_COMISSAO"], "where": ["CODREP = '${codrep}'"]}`, null);

      if (!response) {
        return '30';
      }
      jsonStr = await response.json();
      if (response.status != 200) {
        return '30';
      }
      try {
        const dia = jsonStr.RESULT[0][0].DIA_COMISSAO;
        return dia
      } catch {
        return '30';
      }
    } catch (error) {
      throw new Error('Ocorreu um erro ao buscar o dia de comissão')
    }
  }

  async function validaPagar(obs, codrep, valor) {
    $.LoadingOverlay('show');
    try {
      response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.NUM_AP"], "where": ["PAGTO.OBS LIKE '[PERCENTUAL]${obs}[PERCENTUAL]' AND PAGTO.VALOR = ${parseFloat(valor)} AND PAGTO.CODCRE = '${codrep}'"]}`, null);

      if (!response) {
        return '';
      }
      jsonStr = await response.json();
      if (response.status != 200) {
        return '';
      }
      try {
        const num_ap = jsonStr.RESULT[0][0].NUM_AP;
        return num_ap
      } catch {
        return '';
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnGravarPagar').on('click', async function () {
    await gravaPagar();
  });

  async function gravaPagar() {
    $.LoadingOverlay("show");
    try {
      if ((parseFloat($('#txtValor').val()) <= 0) || ($('#txtValor').val() == "0,00")) {
        msgAlerta('Valor não pode ser 0!');
        return;
      }

      const classe = pegaChave('#txtClasse');
      const situacao = pegaChave('#txtSituacao');
      const fornecedor = pegaChave('#txtFornecedor');
      const banco = pegaChave('#txtBanco');
      const conta = pegaChave('#txtConta');

      if ((classe == '') || (banco == '') || (conta == '') || (situacao == '') || (fornecedor == '')) {
        msgAlerta('Campos obrigatórios não informados.');
        return;
      }
      let PagarC = {};

      PagarC.VALOR = parseFloat($('#txtValor').val());
      PagarC.DOCTO = $('#txtNotaFiscal').val();
      PagarC.VAL_PAG = parseFloat(0);
      PagarC.VAL_NOTA = parseFloat($('#txtValor').val());
      PagarC.VALOR_ORIG = parseFloat($('#txtValor').val());
      PagarC.DT_VEN = `${$('#txtDTvencimento').val()}T00:00:00Z`;
      PagarC.DATA_ORIG = `${$('#txtDTvencimento').val()}T00:00:00Z`;
      PagarC.DT_EMI = `${$('#txtDTemissao').val()}T00:00:00Z`;
      PagarC.STATUS = $('#txtStatus').val();
      PagarC.OBS = $('#txtObs').val();
      PagarC.EMP_ID = getCookie('emp_id');
      PagarC.CODCRE = fornecedor;
      PagarC.SITUACAO = situacao;
      PagarC.NUM_OS = classe;
      PagarC.BANCO = banco;
      PagarC.CONTA = conta;
      PagarC.TELA = "FECHAMENTOCOMISSAO";

      let response = await requisicao(pagar = 'POST', '/Sisplan/pagar/V1/Pagar?', '', `JSON=${encodeURIComponent(JSON.stringify(PagarC))}`);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      if (response.status == 502) {
        await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
      } else if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr.success(
        `AP ${jsonStr.num_ap} gerada com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          deletaRegistro('PAGAR', getCookie('usuario'), jsonStr.num_ap);
        }
      }
      ).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px"
      });
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível gravar os dados do Pagamento: ');

    } finally {
      $('#modal-pagar').modal('hide');
      $.LoadingOverlay('hide');
    }
  }

  $('#modal-pagar').on('hidden.bs.modal', function () {
    $('#txtClasse').val('')
    $('#txtBanco').val('')
    $('#txtConta').val('')
    $('#txtSituacao').val('')
  })

});
