$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#importDrag',
        popover: {
          title: 'Importar Arquivos',
          description: 'Arraste ou selecione um arquivo csv para importação de produto.',
          position: 'bottom'
        }
      },
      {
        element: '#txtCaminhoLogs',
        popover: {
          title: 'Logs',
          description: 'Informe aqui o local para informar os logs.',
          position: 'bottom'
        }
      },
      {
        element: '#btnImportar',
        popover: {
          title: 'Botão Importar',
          description: 'Clique aqui para importar os dados que estão no arquivo csv os pedidos filtrados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {

  async function verificaSeEstaCadastroSeNaoCadastra() {

    async function gravaInfoNaoRegistrada(info) {
      const field = fields.filter((field) => field.tabela === Object.keys(info)[0])[0]
      let obj = {
        [field.camposGravar[0]]: info[field.tabela],
        [field.camposGravar[1]]: info[`DS_${field.campo}`]
      }
      for (const campo of field.camposGravar) {
        if (campo !== field.camposGravar[0] && campo !== field.camposGravar[1]) {
          obj = {
            ...obj,
            [campo]: info[campo],
            ATIVO: 'S'
          }
        }

        if (field.tabela === 'TABFIS') {
          if (campo === 'CODIGO') obj.CODIGO = await RetornaProximo(field.tabela, field.tabela, 'CODIGO', 5);
          if (campo === 'COD_IMPORTADO') obj.COD_IMPORTADO = data.filter((d) => d.NCM = info[field.tabela])[0].CODFIS
          if (campo === 'DESCRICAO') obj.DESCRICAO = info[field.tabela]
          if (campo === 'TIPO') obj.TIPO = info[`DS_${field.campo}`]
        }

        if (field.tabela === 'COLECAO') {
          if (campo === 'CODIGO') obj.CODIGO = await RetornaProximo(field.tabela, field.tabela, 'CODIGO', 2);

          if (campo === 'COD_IMPORTADO') obj.COD_IMPORTADO = info[`${field.tabela}`]

          if (campo === 'DESCRICAO') obj.DESCRICAO = info[`DS_${field.campo}`]
        }

        if (field.tabela === 'AUXILIAR') {
          if (campo === 'TIPO') obj.TIPO = 'PCAT'

          if (campo === 'TIPO_IT') obj.TIPO_IT = 'P'
        }
      }

      const response = await requisicao("POST", field.url, `JSON=${encodeURIComponent(JSON.stringify(obj))}`, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
    }

    const data = $('#tabelaProdutos').DataTable().rows().data().toArray().filter((row) => row.CODIGO !== '');

    if (data.length == 0) {
      return
    }
    // separo os dados por tabela (fields)
    const fields = [
      {
        url: '/sisplan/cadastros/v1/clafiscal?',
        tabela: 'TABFIS',
        campo: 'NCM',
        camposGravar: ['DESCRICAO', 'CODIGO', 'COD_IMPORTADO', 'ATIVO', 'CODFIS', 'TIPO'],
      }, {
        url: '/sisplan/cadastros/v1/cadstatus?',
        tabela: 'SITPROD',
        campo: 'STATUS',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/grupo?',
        tabela: 'GRUPO_PA',
        campo: 'GRUPO',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/linha?',
        tabela: 'TABLIN',
        campo: 'LINHA',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/marca?',
        tabela: 'MARCA',
        campo: 'MARCA',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/colecao?',
        tabela: 'COLECAO',
        campo: 'COLECAO',
        camposGravar: ['COD_IMPORTADO', 'CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/tipoproduto?',
        tabela: 'CAD_TIPO_PROD',
        campo: 'TIPO',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/etiqueta?',
        tabela: 'ETQ_PROD',
        campo: 'ETIQUETA',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/modelo?',
        tabela: 'MODELO',
        campo: 'MODELO',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/auxiliar?',
        tabela: 'AUXILIAR',
        campo: 'CATEGORIA',
        camposGravar: ['ID', 'DESCRICAO', 'TIPO', 'TIPO_IT', 'ATIVO']
      }, {
        url: '/sisplan/cadastros/v1/faixa?',
        tabela: 'FAIXA',
        campo: 'FAIXA',
        camposGravar: ['CODIGO', 'DESCRICAO', 'ATIVO'],
      }, {
        url: '/sisplan/cadastros/v1/grupocor?',
        tabela: 'GRUPO_COR',
        campo: 'GRUPO_COR',
        camposGravar: ['CODIGO', 'DESCRICAO'],
      }, {
        url: '/sisplan/cadastros/v1/subgrupocor?',
        tabela: 'SUBGRUPO_COR',
        campo: 'SUBGRUPO_COR',
        camposGravar: ['CODIGO', 'DESCRICAO'],
      }]


    const dados = {};

    fields.forEach(field => {
      dados[`${field.tabela}`] = data.reduce((acc, current) => {
        if (!acc.some(item => item[field.tabela] === current[field.campo])) {
          acc.push({ [field.tabela]: current[field.campo], [`DS_${[field.campo]}`]: current[`DS_${field.campo}`] });
        }
        return acc;
      }, []);
    });

    // verifico se existe, caso nao irá gravar usando a rota do proprio cadastro

    for (const records of fields) {
      for (const record of dados[records.tabela]) {

        const exists = await Existe(records.tabela, [records.camposGravar[0]], [record[records.tabela]]);
        if (!exists) {
          await gravaInfoNaoRegistrada(record,)
        }
      }
    }

    await gravaCores(data);
    await gravaTamanhos(data);
    await gravaFaixa(data);
    await gravaProdutos(data);
    await gravaBarras(data);

    toastr.success(
      'Importação dos produtos realizada com sucesso!',
      'Confirmação', {
      toastClass: 'alert',
      iconClasses: {
        error: 'alert-error',
        info: 'alert-info',
        success: 'alert-success',
        warning: 'alert-warning'
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden: function () {
        window.location.reload();
      }
    }
    ).css({
      "margin-top": "20%",
      "width": "500px",
      "max-width": "500px"
    });
  }

  function montaObjTamanhos(data) {

    const tamanhos = data.reduce((acc, current) => {
      if (!acc.some(item => item.TAM === current.TAM)) {
        acc.push(current);
      }
      return acc;
    }, []);

    return tamanhos.map((tam) => {
      return {
        TAM: tam.TAM,
        FAIXA: tam.FAIXA,
        ACRESCIMO: tam.POSICAO_TAM
      }
    })
  }

  function montaObjFaixasItem(data) {
    const tamanhos = data.reduce((acc, current) => {
      if (!acc.some(item => item.TAM === current.TAM)) {
        acc.push(current);
      }
      return acc;
    }, []);

    return tamanhos.map((tam) => {
      return {
        TAMANHO: tam.TAM,
        FAIXA: tam.FAIXA,
        ACRESCIMO: tam.POSICAO_TAM,
        PERCENTUAL: 0
      }
    })
  }

  function montaObjCores(data) {
    const cores = data.reduce((acc, current) => {
      if (!acc.some(item => item.COR === current.COR)) {
        acc.push(current);
      }
      return acc;
    }, []);

    return cores.map((cor) => {
      return {
        CODIGO: cor.CODIGO,
        COR: cor.COR,
        DESCRICAO: cor.DS_COR,
        COD_IMPORTADO: cor.COD_COR_IMPORTADO,
        INATIVO: cor.INATIVO_COR,
        TAM: cor.TAM,
        QUANTIDADE: cor.QUANTIDADE,
        DEPOSITO: cor.DEPOSITO,
      }
    })
  }

  function montaObjPaIten(data) {
    const cores = data.reduce((acc, current) => {
      if (!acc.some(item => (item.COR === current.COR && item.TAM === current.TAM))) {
        acc.push(current);
      }
      return acc;
    }, []);

    return cores.map((cor) => {
      return {
        CODIGO: cor.CODIGO,
        COR: cor.COR,
        DESCRICAO: cor.DS_COR,
        COD_IMPORTADO: cor.COD_COR_IMPORTADO,
        INATIVO: cor.INATIVO_COR,
        TAM: cor.TAM,
        QUANTIDADE: cor.QUANTIDADE,
        DEPOSITO: cor.DEPOSITO,
        BARRA: cor.BARRA,
        BARRA28: cor.BARRA28,
        BARRACLI: cor.BARRACLI,
      }
    })
  }

  async function gravaCores(data) {
    const cores = montaObjCores(data)
    for (const cor of cores) {

      const response = await requisicao('POST', '/sisplan/cadastros/v1/cadcor?', `JSON=${encodeURIComponent(JSON.stringify(cor))}`, '', 600000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
    }
  }

  async function gravaTamanhos(data) {
    const tamanhos = montaObjTamanhos(data);
    for (const tam of tamanhos) {

      if (!await Existe('TABTAM', ['TAM', 'ACRESCIMO'], [tam.TAM, tam.ACRESCIMO])) {
        if (await Existe('TABTAM', ['ACRESCIMO'], [tam.ACRESCIMO])) {
          return;
        }

        const response = await requisicao('POST', '/sisplan/cadastros/v1/tamanho?', `JSON=${encodeURIComponent(JSON.stringify(tam))}`, '', 600000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }
      }
    }
  }

  async function gravaFaixa(data) {
    const tamanhos = montaObjFaixasItem(data);
    for (const tam of tamanhos) {

      if (!await Existe('FAIXA_ITEN', ['FAIXA', 'TAMANHO'], [tam.FAIXA, tam.TAMANHO])) {
        const response = await requisicao('POST', '/sisplan/cadastros/v1/tamanhofaixa?', `JSON=${encodeURIComponent(JSON.stringify(tam))}`, '', 600000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }
      }
    }
  }

  async function gravaProdutos(data) {

    const produtos = data.reduce((acc, current) => {
      if (!acc.some(item => item.CODIGO === current.CODIGO)) {
        acc.push(current);
      }
      return acc;
    }, []);

    for (const produto of produtos) {

      if (!await Existe('PRODUTO', ['CODIGO'], [produto.CODIGO])) {
        const cores = montaObjPaIten(data.filter((prod) => prod.CODIGO === produto.CODIGO));
        // const colecao = await buscaValor('COLECAO', 'CODIGO', 'COD_IMPORTADO', produto.COLECAO);
        const ncm = await buscaValor('TABFIS', 'CODIGO', 'DESCRICAO', produto.NCM);

        if (!ncm) {
          msgAlerta(`NCM ${produto.NCM} não cadastrado, necessário cadastrar antes de importar os produtos.`);
          return;
        }

        const obj = {
          ...produto,
          PRECO: TruncaDecimaisNova(2, parseFloat(produto.PRECO.replace(',', '.'))),
          PRECO_COM: TruncaDecimaisNova(2, parseFloat(produto.PRECO_COM.replace(',', '.'))),
          PRECO_COM_COR_TAM: TruncaDecimaisNova(2, parseFloat(produto.PRECO_COM_COR_TAM.replace(',', '.'))),
          PRECO_MED: TruncaDecimaisNova(2, parseFloat(produto.PRECO_MED.replace(',', '.'))),
          PRECO_REPOS_COR_TAM: TruncaDecimaisNova(2, parseFloat(produto.PRECO_REPOS_COR_TAM.replace(',', '.'))),
          PRECO_VEN_COR_TAM: TruncaDecimaisNova(2, parseFloat(produto.PRECO_VEN_COR_TAM.replace(',', '.'))),
          REPOSICAO: TruncaDecimaisNova(2, parseFloat(produto.REPOSICAO.replace(',', '.'))),
          CUSTO: TruncaDecimaisNova(2, parseFloat(produto.CUSTO.replace(',', '.'))),
          CORES: cores,
          COLECAO: produto.COLECAO,
          CODFIS: ncm.CODIGO
        }

        const response = await requisicao('POST', '/sisplan/cadastros/v1/produto?', '', JSON.stringify(obj), 600000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }

      }
    }
  }

  async function gravaBarras(data) {
    const produtos = data.reduce((acc, current) => {
      if (!acc.some(item => item.CODIGO === current.CODIGO)) {
        acc.push(current);
      }
      return acc;
    }, []);
    for (const produto of produtos) {
      const cores = montaObjPaIten(data.filter((prod) => prod.CODIGO === produto.CODIGO));
      const obj = cores.map((cor) => {
        // if (cor.BARRA != '') {
        return {
          CODIGO: cor.CODIGO,
          COR: cor.COR,
          TAMANHO: cor.TAM,
          BARRA: cor.BARRACLI ?? '',
          BARRAITEN: cor.BARRA ?? '',
          BARRA28: cor.BARRA28 ?? '',
          CUSTO: cor.CUSTO ?? 0,
          PRECOREPOS: cor.PRECO_REPOS ?? 0,
          PRECOCOM: cor.PRECO_COM ?? 0,
          PRECOVEN: cor.PRECO_VEN ?? 0,
          TIPO: 'P',
          ESPECIEBARRA: 'BARRA',
        }
      })
      for (const element of obj) {

        const response = await requisicao('PUT', '/sisplan/estoque/v1/atualizabarrasproduto?', '', JSON.stringify(element), 600000);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }
      }
    }
  }

  $('#btnImportar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const data = $('#tabelaProdutos').DataTable().rows().data().toArray();

      if (data.length == 0) {
        msgAlerta('Selecione um arquivo para importar.')
        return;
      }

      await verificaSeEstaCadastroSeNaoCadastra()

    } catch (e) {
      console.error(e)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $("#importDrag").on("dragover", function (event) {
    event.preventDefault();
    $(".importFile").addClass("dragover");
  });

  $("#importDrag").on("dragleave", function () {
    $(".importFile").removeClass("dragover");
  });

  $("#importDrag").on("drop", function (event) {
    event.preventDefault();
    $(".importFile").removeClass("dragover");

    let files = event.originalEvent.dataTransfer.files;
    if (files.length > 0) {
      leArquivoCSV(files[0]);
    }
  });

  $("#fileImportCSV").on("change", async function () {
    $.LoadingOverlay("show");
    try {
      const fileAnexo = document.querySelector('#fileImportCSV').files[0];

      leArquivoCSV(fileAnexo);
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  function leArquivoCSV(arquivo) {
    if (!arquivo) {
      return msgAlerta('Nenhum arquivo identificado')
    }
    if (arquivo && arquivo.type !== "text/csv" && !arquivo.name.endsWith(".csv")) {
      msgAlerta("Apenas arquivos CSV são permitidos.");
      arquivo.target.value = "";
      return;
    }

    if ($.fn.DataTable.isDataTable('#tabelaProdutos')) {
      $('#tabelaProdutos').DataTable().clear().draw(false);
      $("#tabelaProdutos").DataTable().destroy();
      $("#tabelaProdutos").empty();
    }

    return new Promise((resolve, reject) => {
      Papa.parse(arquivo, {
        header: true,
        skipEmptyLines: true,
        complete: (results) => {
          try {
            const objeto = results.data.filter((obj) => obj.CODIGO !== '')
            const dataSetCols = []
            var keys = Object.keys(objeto[0]);
            for (var k in keys) {
              dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
              });
            }

            $('#tabelaProdutos').DataTable({
              sort: false,
              paging: true,
              destroy: true,
              lengthChange: true,
              filter: true,
              info: false,
              ordering: false,
              sorting: false,
              order: false,
              autoWidth: true,
              data: objeto,
              columns: dataSetCols,
              scrollX: true,
              scrollY: '415px',
              colReorder: true,
              select: {
                style: 'single',
                toggleable: false,
              },
            })
            $('#divTabelaProdutos').removeClass('d-none')
            $('#divTabelaProdutos').addClass('d-flex')
            setTimeout(() => {

              $(`#tabelaProdutos`).DataTable().columns.adjust().draw(false);
            }, 1000);
          } catch (error) {
            reject(error);
          }
        },
        error: (error) => {
          reject(error);
        }
      });
    });
  }

});
