$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORCAMENTO");
  let consultando = true
  await VinculaCaixaComUsuario()
  const paramVen54 = await CopiaParametro('VENDA', 54);

  if (pegaValor('#txtCaixa') == '') {
    $("#txtCaixa").val(sessionStorage.getItem('g_caixa_logado'));
  }

  $('#txtValor').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  const filtrarSomentePedidosRepresentanteUsuarioLogado = await CopiaParametro('PEDIDO', 14) == 1
  const objetoFiltroRepresentante = {
    filtrar: false,
    codigoRepresentante: '',
  }
  if (filtrarSomentePedidosRepresentanteUsuarioLogado) {
    codigoRepresentante = retornaRepresentanteUsuario()
    if (codigoRepresentante) {
      objetoFiltroRepresentante.filtrar = true
      objetoFiltroRepresentante.codigoRepresentante = codigoRepresentante
    }
  }

  await preencheOrdenacaoTela('RelAcessoOrcamento')
  await preencheOrdenacaoTela('OrcamentoIndividual', 'txtOrdemIndividual', 'ordemRelatorioIndividual')

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.orcamento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, orcamento: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, orcamento: novasColunas }))
      $('#tabelaOrcamento').DataTable().columns().visible(true);
      $('#tabelaOrcamento').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaOrcamento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });
    adicionaColunas(cols, colunasInvisiveis.orcamento ?? [], ['NUMERO'])

  })

  await adicionaPesquisaFiltros()
  await buscaDadosOs()
  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == "S") {
      window.location.href = "orcamento/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnConsultar').on('click', async function () {
    await buscaDadosOs()
    $("#modal-filtros").modal("hide");
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const representanteUsuario = await retornaRepUsuario()
    const situacao = $('#rgAberto').is(':checked') ? 1 : $('#rgFechado').is(':checked') ? 2 : $('#rgEmAprovacao').is(':checked') ? 3 : $('#rgPerdido').is(':checked') ? 4 : 0
    const situacaoItem = $('#rgItensAprovado').is(':checked') ? 1 : $('#rgItensReprovado').is(':checked') ? 2 : $('#rgItensBloquetado').is(':checked') ? 3 : 0
    const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')]
    const filtros = `DTCADASTRODE=${$('#txtDtCadastroI').val()}` +
      `&DTCADASTROATE=${$('#txtDtCadastroF').val()}` +
      `&DTSAIDADE=${$('#txtDtSaidaI').val()}` +
      `&DTSAIDAATE=${$('#txtDtSaidaF').val()}` +
      `&DTENTREGADE=${$('#txtDtEntregaI').val()}` +
      `&DTENTREGAATE=${$('#txtDtEntregaF').val()}` +
      `&DTDIGITACAODE=${$('#txtDtDigitacaoI').val()}` +
      `&DTDIGITACAOATE=${$('#txtDtDigitacaoF').val()}` +
      `&SITUACAO=${situacao}` +
      `&SITUACAOITEM=${situacaoItem}` +
      `&NUMEROS=${await formataListas($('#txtNumero').val().toString())}` +
      `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
      `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&GRUPO=${await formataListas($('#txtGrupoPA').val().toString())}` +
      `&ETIQUETA=${await formataListas($('#txtEtiqueta').val().toString())}` +
      `&LINHA=${await formataListas($('#txtLinha').val().toString())}` +
      `&EMPRESAS=${await formataListas(empresas.toString())}` +
      `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
      `&REPUSUARIO=${representanteUsuario}`;

    return filtros
  }

  async function buscaDadosOs() {
    $.LoadingOverlay('show')
    consultando = true
    try {
      const url = "/sisplan/orcamento/v1/buscadadosacesso?"
      const filtros = await retornaFiltros()
      const response = await requisicao('GET', url, filtros, null, 180000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        throw msgAlerta(jsonStr.mensagem);
      }

      if (jsonStr.length <= 0) {
        throw msgAlerta('Nenhum registro encontrado!');
      }

      await montaDataTableAcesso(jsonStr)

    } catch (error) {
      $('#modal-filtros').modal('hide')
    } finally {
      $.LoadingOverlay('hide')
      consultando = false
    }
  }

  async function retornaRepUsuario() {
    const filtraClientesRepresentante = await CopiaParametro('SISTEMA', 2) == 1;

    if (!filtraClientesRepresentante) {
      return '';
    }

    const usuarioMasterSupervisor = await uMasterOuSupervisor()

    if (usuarioMasterSupervisor) {
      return ''
    }

    const repUsuario = retornaRepresentanteUsuario()

    return `'${repUsuario}'`
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '    <button class="dropdown-item" title="Duplicar" id="btnDuplicar">Duplicar</button>     ' +
      `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelOrcamentoIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>` +
      `    <button id="btnGerarPedido" type="button" class="dropdown-item">Gerar Pedido</button>` +
      '    <button class="dropdown-item" title="Anexos" id="btnAnexos">Gestão de Documentos</button>     ' +
      '</div>';
    return retorno;
  };

  async function montaDataTableAcesso(jsonStr) {
    if ($.fn.DataTable.isDataTable('#tabelaOrcamento')) {
      $('#tabelaOrcamento').DataTable().destroy();
      $('#tabelaOrcamento').empty();
    }
    let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
    ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

    const dataSetCols = [];
    let keys
    if (ordemColunasRelatorio != null && ordemColunasRelatorio.orcamento != undefined) {
      const ordenacao = 'GERAL'
      const colunas = ordemColunasRelatorio.orcamento.filter(f => f.ordenacao == ordenacao)
      keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(jsonStr[0]);
    } else {
      keys = Object.keys(jsonStr[0]);
    }

    const colunasOriginais = Object.keys(jsonStr[0])

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaOrcamento').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [keys.indexOf(colunasOriginais[6]), keys.indexOf(colunasOriginais[7]), keys.indexOf(colunasOriginais[8]), keys.indexOf(colunasOriginais[9]), keys.indexOf(colunasOriginais[10])]
        },
        {
          targets: [keys.indexOf(colunasOriginais[15]), keys.indexOf(colunasOriginais[19]), keys.indexOf(colunasOriginais[20]), keys.indexOf(colunasOriginais[21]), keys.indexOf(colunasOriginais[26]), keys.indexOf(colunasOriginais[27]), keys.indexOf(colunasOriginais[28])],
          render(data) {
            return parseFloat(data).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            });
          },
          "className": 'pr-4 text-right'
        },
        {
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          },
        },
        {
          targets: [keys.indexOf(colunasOriginais[11])],
          render(data) {
            if (data) {
              switch (data) {
                case 'A':
                  return 'Aberto'
                  break;
                case 'F':
                  return 'Fechado'
                  break;
                case 'E':
                  return 'Em Aprovação'
                  break;
                case 'P':
                  return 'Perdido'
                  break
                default:
                  return 'Outro'
                  break;
              }
            } else {
              return 'Outro'
            }
          }
        }
      ]
    });

    $('#tabelaOrcamento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaOrcamento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaOrcamento').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.orcamento).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $('#buttonExcel').off()
    $('#buttonExcel').on('click', async function () {
      const dados = $("#tabelaOrcamento").DataTable().data().toArray();
      await exportaCSV('', null, false, null, 'Relatório de Orçamento', '#tabelaOrcamento', '', 999, false, false, dados)
    })

    $('#tabelaOrcamento').on('column-reorder.dt', function (e, settings, details) {
      if (consultando) {
        return
      }
      let newColumnOrder = []

      for (let i = 0; i < settings.aoColumns.length; i++) {
        const column = settings.aoColumns[i].mData

        newColumnOrder.push(column)
      }

      newColumnOrder = newColumnOrder.filter(item => item != 'NUMERO')
      newColumnOrder.unshift('NUMERO')

      let ordemColunas = localStorage.getItem('ordemColunasDataTable')
      ordemColunas = JSON.parse(ordemColunas)
      const ordenacao = 'GERAL'

      if (ordemColunas == null || ordemColunas.orcamento == undefined) {
        localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, orcamento: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

      } else if (!ordemColunas.orcamento.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
        ordensSalvas.orcamento.push(newObj)
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

      } else if (ordemColunas.orcamento.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        ordensSalvas.orcamento.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
      }
    });

  }

  async function validacaoModifica(numero, exclusao = false) {
    const pesquisa = {
      camposSelect: ["RECEBER.NUMERO REC, OS.SITUACAO"],
      tabela: "OS",
      leftjoin: [{ tabela: "RECEBER", condicao: "RECEBER.CARTAO_PRESENTE = OS.NUMERO" }],
      where: [`OS.NUMERO = '${numero}'`],
      limit: 1
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));


    if (exclusao && jsonStr[0].REC != '' && jsonStr[0].REC != null) {
      throw new Error(`Existe Antecipação gerada com número ${jsonStr[0].REC} Impossível continuar.`)
    }

    if (jsonStr[0].SITUACAO == 'F') {
      throw new Error(`Situação do orçamento já fechada, impossível continuar.`)
    }
  }

  $("#tabelaOrcamento").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data.NUMERO, data.CODCLI + ' ' + data.NOME_CLI, 'ORCAMENTO');
  });

  $("#tabelaOrcamento").on('click', "#btnDuplicar", async function () {
    const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();
    $('#txtAntigoNumero').val(data.NUMERO)
    $('#modalDuplicar').modal('show')
  });

  $('#btnConfirmaDuplicar').on('click', async function () {
    if (!$('#txtNovoNumero').val()) {
      throw msgAlerta('Necessário informar um novo número para o orçamento');
    }
    if (await Existe('OS', ['NUMERO'], [$('#txtNovoNumero').val()])) {
      throw msgAlerta('Número de orçamento já existe, deve inserir um número diferente.')
    }
    try {
      $.LoadingOverlay('hide');

      let response = await requisicao("POST", "/sisplan/orcamento/v1/duplicar?", `NUMERO=${$('#txtAntigoNumero').val()}&NOVO_NUMERO=${$('#txtNovoNumero').val()}`, null, 50000);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        let jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr.success("Orçamento duplicado com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/orcamento`;
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $("#tabelaOrcamento").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $("#tabelaOrcamento")
        .DataTable()
        .row($(this).parents("tr"))
        .data();

      if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
        msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível alterar!')
        return
      }
      if (data.SITUACAO == 'F') {
        msgAlertaSemConfirmacao('Orçamento fechado. Impossível alterar!')
        return
      }
      const orcamentoLiberado = await verificarRegistro("ORCAMENTO", data.NUMERO);
      if (orcamentoLiberado) {
        window.location.href = `orcamento/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaOrcamento").on("click", "#btnExcluir", async function () {
    $.LoadingOverlay("show");
    try {
      if (permissaoUsuarioLogado.EXCLUI == "S") {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
          const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr"));
          await deletaOs(data);
        });
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $("#tabelaOrcamento").on("click", "#btnGerarPedido", async function () {
    $.LoadingOverlay("show");
    try {
      const permissaoUsuarioLogadoPedido = await permissaoAcessos("PEDIDO");
      if (permissaoUsuarioLogadoPedido.INCLUI == "S") {
        msgAlerta('Deseja criar um Pedido a partir da Proposta Comercial?', async () => {
          const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr")).data();
          if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
            msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível gerar pedido!')
            return
          }
          await gerarPedido(data);
        });
      } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir pedidos!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })


  async function deletaOs(data) {
    $.LoadingOverlay('show')
    try {
      let numero = data.data().NUMERO;

      await validacaoModifica(numero, true)

      let response = await requisicao("DELETE", "/sisplan/os/v1/ordemservico?", `NUMERO=${numero}`, null, 50000);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        let jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          data.remove().draw(false);
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnLimparFiltros').on('click', async function () {
    limparFiltros()
  })

  function limparFiltros() {
    $('#txtDtCadastroI').val('1200-01-01')
    $('#txtDtCadastroF').val('2500-12-01')
    $('#txtDtSaidaI').val('1200-01-01')
    $('#txtDtSaidaF').val('2500-12-01')
    $('#txtDtEntregaI').val('1200-01-01')
    $('#txtDtEntregaF').val('2500-12-01')
    $('#txtDtDigitacaoI').val('1200-01-01')
    $('#txtDtDigitacaoF').val('2500-12-01')
    $('#rgTodos').prop('checked', true)
    $('#rgItensTodos').prop('checked', true)
    $('#txtNumero').empty().trigger('change')
    $('#txtCliente').empty().trigger('change')
    $('#txtProduto').empty().trigger('change')
    $('#txtGrupoPA').empty().trigger('change')
    $('#txtEtiqueta').empty().trigger('change')
    $('#txtLinha').empty().trigger('change')
  }

  retornaHintRelatorio('btnImprimir', 'RelAcessoOrcamento')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/orcamento/v1/imprimiracesso?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoOrcamento');
        const ordem = `&TELA_ORDENACAO=RelAcessoOrcamento&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelAcessoOrcamento');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#tabelaOrcamento").on("click", "#btn-imprimirIndividual", async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimeorcamentoindividual?`;

      const filtros = `NUMERO=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrcamentoIndividual');
      const ordem = `&TELA_ORDENACAO=OrcamentoIndividual&ORDEM_ORDENACAO=${$('#txtOrdemIndividual').val()}`;
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 150000, false, 'RelOrcamentoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function retornaItens(numOs) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: "OS_ITEN",
        camposSelect: [
          "CODIGO", "PROTOTIPO", "COR", "TAM", "QTDE", "PRECO", "ORDEM_DIG", "OBS2", "TIPO_PROD", "NUMERO"
        ],
        where: [`NUMERO = '${numOs}'`]
      };

      const jsonStrItens = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let arrItens = [];
      for (let i = 0; i < jsonStrItens.length; i++) {
        const item = jsonStrItens[i]
        let prototipo = await buscaValor('PRODUTO', 'CODIGO', 'PROTOTIPO', item.PROTOTIPO);
        let codigo = item.CODIGO
        if (prototipo != undefined && item.CODIGO == '' && prototipo.CODIGO == '') {
          const responseCodProduto = await requisicao('PUT', '/sisplan/orcamento/v1/geracodigoproduto?', `NUMERO=${item.NUMERO}&PROTOTIPO=${item.PROTOTIPO}`, null, 90000);

          if (!responseCodProduto) {
            $.LoadingOverlay('hide');
            return;
          }

          const jsonStrCodProd = await responseCodProduto.text();
          if (responseCodProduto.status != 200) {
            $.LoadingOverlay('hide');
            msgErro(jsonStrCodProd.mensagem);
            return;
          }

          prototipo = await buscaValor('PRODUTO', 'CODIGO', 'PROTOTIPO', item.PROTOTIPO);
        }

        if ((item.TIPO_PROD == 'N' || item.TIPO_PROD == 'P') || (!await Existe('PRODUTO', ['CODIGO'], [item.CODIGO]))) {
          codigo = prototipo.CODIGO
        }

        arrItens.push({
          CODIGO: codigo != '' ? codigo : prototipo.CODIGO,
          COR: item.COR,
          TAM: item.TAM,
          QTDE: item.QTDE,
          QTDE_ORIG: item.QTDE,
          PRECO: item.PRECO,
          PRECO_ORIG: item.PRECO,
          TIPO: 'P',
          QUALIDADE: '1',
          ORDEM: item.ORDEM_DIG,
          OBSERVACAO: item.OBS2
        })
      }

      return arrItens;

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function retornaRecSimula(numeroPed, numOs) {
    $.LoadingOverlay('show')
    try {
      let sCondicoes = '';
      let valEntrada;
      const pesquisaParam = {
        tabela: "OS_SIMULA",
        camposSelect: [
          "VENCTO", "VALOR_PARCELA", "VALOR_TOTAL", "NUM_PARCELA", "DT_FATURA", "MOEDA", "VAL_ENT_PED"
        ],
        where: [`NUMERO = '${numOs}'`]
      };

      const jsonStrRec = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let arrRec_Simula = [];
      let arrCondicoes = [];
      let i = 1;
      jsonStrRec.map((item, index) => {
        const dtFatura = new Date(item.DT_FATURA);
        const vencto = new Date(item.VENCTO);
        const diffTime = Math.abs(dtFatura - vencto);
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

        let diffStr = diffDays.toString()

        arrCondicoes.push({
          DIAS: diffStr,
          DT_VENCTO: item.VENCTO,
          MOEDA: item.MOEDA,
          VALOR: item.VALOR_PARCELA,
          TIPO: 'P',
          NUMERO: numeroPed,
          ORDEM: i++
        })

        while (diffStr.length < 3) {
          diffStr = diffStr + ' ';
        }

        sCondicoes += diffStr;

        valEntrada = item.VAL_ENT_PED;

        arrRec_Simula.push({
          PEDIDO: numeroPed,
          VENCTO: item.VENCTO,
          VALOR_PARCELA: item.VALOR_PARCELA,
          VALOR_TOTAL: item.VALOR_TOTAL,
          NUM_PARCELA: item.NUM_PARCELA,
          DT_FATURA: item.DT_FATURA
        })
      });

      return { arrRecSimula: arrRec_Simula, pgto: sCondicoes.trim(), condicoes: arrCondicoes, valEntrada };

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function gerarPedido(data) {
    $.LoadingOverlay('show')
    try {
      if (await Existe('PEDIDO', ['ORCAMENTO'], [data.NUMERO])) {
        throw new Error('Orçamento já virou pedido, impossível continuar.');
      }

      const parametrosComercial = await BuscaParametrosPedido();
      const bNaoGeraCondPagto = parametrosComercial[15].VALOR == '1';

      const sNumero = await RetornaProximo('NUMERO', 'PEDIDO', 'NUMERO', 5)

      const pesquisaParam = {
        tabela: "OS",
        camposSelect: [
          "CLIENTE", "CODREP", "CIF", "COM1", "COM2", "DT_ENTREGA", "DEPOSITO",
          "TAB_TRANS", "EMP_FAT", "DT_SAIDA", "PED_CLI", "MOEDA", "SIT_DUP",
          "CLASSE_GER", "HISTORICO", "STATUS", "FRETE", "NATUREZA", "PESO_BRUTO",
          "PESO_LIQ", "VOLUMES", "PER_DESC", "PRZ_MEDIO", "OBS", "BLOQ_COM", "TAB_PRE"
        ],
        where: [`NUMERO = '${data.NUMERO}'`]
      };

      const jsonStrPed = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let tabPre = jsonStrPed[0].TAB_PRE

      if (!tabPre) {
        tabPre = '999'
      }

      const recSimula = await retornaRecSimula(sNumero, data.NUMERO)
      const arrRecSimula = recSimula.arrRecSimula
      const pgto = recSimula.pgto

      const condPgto = bNaoGeraCondPagto ? [] : recSimula.condicoes;
      const valEntrada = recSimula.valEntrada

      const arrItens = await retornaItens(data.NUMERO)

      const dadosOs = jsonStrPed[0]
      const pedido = {
        NUMERO: sNumero,
        PED_CLI: dadosOs.PED_CLI,
        CODCLI: dadosOs.CLIENTE,
        CODREP: dadosOs.CODREP,
        CIF: dadosOs.CIF,
        COM1: dadosOs.COM1,
        COM2: dadosOs.COM2,
        DTDIGITA: retornaDataAtual(),
        DT_EMISSAO: retornaDataAtual(),
        TAB_TRANS: dadosOs.TAB_TRANS,
        FATURA: 100,
        EMP_FAT: dadosOs.EMP_FAT,
        DT_SAIDA: dadosOs.DT_SAIDA,
        DT_FATURA: dadosOs.DT_SAIDA,
        ENTREGA: dadosOs.DT_ENTREGA,
        IND_QTDE: 100,
        TAB_PRE2: '00',
        BLOQUEIO: dadosOs.BLOQ_COM,
        FINANCEIRO: parametrosComercial[2].VALOR,
        PERIODO: '0',
        MOEDA: dadosOs.MOEDA,
        SIT_DUP: dadosOs.SIT_DUP,
        CLASSE_GER: dadosOs.CLASSE_GER,
        HISTORICO: dadosOs.HISTORICO,
        STATUS: dadosOs.STATUS,
        STATUS_PED: dadosOs.STATUS,
        ID_TIPO: 0,
        FRETE: dadosOs.FRETE,
        NATUREZA: dadosOs.NATUREZA,
        PESO_BRUTO: dadosOs.PESO_BRUTO,
        PESO_LIQ: dadosOs.PESO_LIQ,
        VOLUMES: dadosOs.VOLUMES,
        PGTO: pgto,
        PER_DESC: dadosOs.PER_DESC,
        ORCAMENTO: data.NUMERO,
        BONIFICACAO: 'N',
        PRZ_MEDIO: dadosOs.PRZ_MEDIO,
        OBS: dadosOs.OBS,
        REC_SIMULA: arrRecSimula,
        EMP_ID: getCookie('emp_id'),
        DEPOSITO: dadosOs.DEPOSITO,
        TAB_PRE: tabPre,
        COND_PAGTOS: condPgto,
        ITENS: arrItens
      };

      const response = await requisicao('POST', '/sisplan/pedido/v1/pedido?', `&BARRAS_LOG=${encodeURIComponent(JSON.stringify({ BARRAS: [] }))}`, encodeURIComponent(JSON.stringify(pedido)), 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');

      if (valEntrada && valEntrada > 0) {
        msgAlerta('Deseja gerar uma antecipação com o valor de entrada?',
          async () => { await abreModalAntecipacao(data.NUMERO, sNumero, valEntrada) },
          () => { callBackImprimir(data.NUMERO, sNumero) },
          () => { },
          () => { callBackImprimir(data.NUMERO, sNumero) },
        )
      } else {
        callBackImprimir(data.NUMERO, sNumero)
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function callBackImprimir(orcamento, sNumero) {
    msgAlerta('Deseja imprimir o pedido?',
      async () => { await imprimirPedido(sNumero); callBack(); },
      () => { callBack(sNumero); },
      () => { },
      () => { callBack(sNumero); });

    function callBack() {
      criaMensagemSucesso(`Pedido ${sNumero} gravado com sucesso!`, async () => {
        await alteraStatusOs(orcamento, sNumero)
      });
    }
  }

  async function abreModalAntecipacao(orcamento, numero, valorEntrada) {
    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO',
        camposSelect: ['PEDIDO.CODCLI', 'PEDIDO.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'PEDIDO.CODREP', 'REPRESEN.NOME NOME_REPRESEN',
          'PEDIDO.NUMERO', 'ENTIDADE.NOME'],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
          { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = PEDIDO.CLASSE_GER' },
          { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = PEDIDO.CODREP' },
        ],
        where: [`PEDIDO.NUMERO = '${numero}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      $('#txtDTvencimento').val('');
      insereValor('#txtPedidoAnte', jsonStr[0].NUMERO);
      insereValor('#txtOrcamentoAnte', orcamento);
      insereValor('#txtClienteAnte', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtRepresenAnte', jsonStr[0].CODREP, jsonStr[0].NOME_REPRESEN);
      insereValor('#txtClasseGer', jsonStr[0].CLASSE_GER, jsonStr[0].DESC_CLASSE);
      insereValor('#txtValor', ArredondarValor(valorEntrada, 2));
      setarDataAtual('txtDTemissao');
      $('#txtDTemissao').prop('disabled', true);
      $('#txtDTemissao').prop('readonly', true);

      await carregaValoresPadroesAnte()
    } finally {
      $.LoadingOverlay('hide');
      addPesquisaAntecipacao()
      $('#modalAntecipacao').modal('show');
    }
  }


  $('#txtDTvencimento').on('blur', function () {
    const dtVencto = $('#txtDTvencimento').val();
    const dtEmissao = $('#txtDTemissao').val();

    if (dtVencto == '') {
      return;
    }

    if (new Date(dtVencto) < new Date(dtEmissao)) {
      msgAlerta('Data de vencimento menor que a data de emissão, favor verificar.');
      $('#txtDTvencimento').val('');
      return;
    }
  });

  $('#txtMoeda').on('blur', async function () {
    const moeda = pegaChave('#txtMoeda');

    if (moeda == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'MOEDA',
      camposSelect: ['MOEDA.HISTORICO', 'HISTCP.DESCRICAO', 'MOEDA.TIPO', "MOEDA_CONTA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA", "CADCONTA.BANCO", "CADBAN.NOME_BANCO"],
      leftJoin: [{ tabela: 'HISTCP', condicao: 'MOEDA.HISTORICO = HISTCP.HISTORICO' },
      { tabela: "MOEDA_CONTA", condicao: `MOEDA.CODMOE = MOEDA_CONTA.MOEDA AND MOEDA_CONTA.EMPRESA = '${getCookie("empresa").substring(1)}'` },
      { tabela: "CADCONTA", condicao: "MOEDA_CONTA.CONTA = CADCONTA.CONTA" },
      { tabela: "CADBAN", condicao: "CADCONTA.BANCO = CADBAN.BANCO" }],
      where: [`MOEDA.CODMOE = '${moeda}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    $('#cartao').addClass('d-none');
    $('#cbNaoLancaCc').prop('checked', false);
    $('#labelNaoLancaCc').addClass('d-none');
    $('#cbNaoLancaCc').addClass('d-none');
    if (jsonStr[0].TIPO == '3') {
      $('#labelNaoLancaCc').removeClass('d-none');
      $('#cbNaoLancaCc').removeClass('d-none');
      $('#cartao').removeClass('d-none');
      await addBandeira();
    }

    insereValor('#txtHistorico', jsonStr[0].HISTORICO, jsonStr[0].DESCRICAO);

    if (jsonStr[0].CONTA != "") {
      insereValor("#txtConta", jsonStr[0].CONTA, jsonStr[0].DESC_CONTA);
      bloqueiaCampoConta(true);
    } else {
      $("#txtConta").val("");
      bloqueiaCampoConta(false);
    }

    if (jsonStr[0].BANCO != "") {
      insereValor("#txtBanco", jsonStr[0].BANCO, jsonStr[0].NOME_BANCO);
      bloqueiaCampoBanco(true);
    } else {
      $("#txtBanco").val("");
      bloqueiaCampoBanco(false);
    }

  });

  $('#txtConta').on('blur', async function () {
    if (pegaValor('#txtConta') == '') {
      return;
    }

    const conta = pegaChave('#txtConta');

    const pesquisaParam = {
      tabela: 'CADCONTA',
      camposSelect: ['CADCONTA.BANCO', 'CADBAN.NOME_BANCO'],
      leftJoin: [{ tabela: 'CADBAN', condicao: 'CADCONTA.BANCO = CADBAN.BANCO' },],
      where: [`CADCONTA.CONTA = '${conta}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtBanco', jsonStr[0].BANCO, jsonStr[0].NOME_BANCO);
  });

  $('#btnConfirmarAnte').on('click', async function gravaReceber() {
    if ((pegaValor('#txtMoeda') == '') || (pegaValor('#txtHistorico') == '') || (pegaValor('#txtClasseGer') == '') || (pegaValor('#txtSituacao') == '') || (pegaValor('#txtConta') == '') ||
      (pegaValor('#txtBanco') == '') || (pegaValor('#txtDTemissao') == '') || (pegaValor('#txtDTvencimento') == '') || (pegaValor('#txtCaixa') == '') || (pegaValor('#txtValor') == '')) {
      msgAlerta('Necessário preencher todos os campos para gravar a antecipação, favor verificar.')
      return;
    }

    if (!$('#cartao').hasClass('d-none') && ((pegaValor('#txtNSU') == '') || (pegaValor('#txtCondicaoDePagamento') == ''))) {
      msgAlerta('Necessário preencher todos os campos para gravar a antecipação, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const receberClass = {
        VALOR: parseFloat(pegaValor('#txtValor')),
        VALOR2: parseFloat(pegaValor('#txtValor')),
        DT_EMISSAO: `${$('#txtDTemissao').val()}T00:00:00Z`,
        DT_VENCTO: `${$('#txtDTvencimento').val()}T00:00:00Z`,
        STATUS: 'ANTE',
        OBS: `Antecipação do pedido ${pegaValor('#txtPedidoAnte')}.`,
        CODREP: pegaChave('#txtRepresenAnte'),
        CODCLI: pegaChave('#txtClienteAnte'),
        SITUACAO: pegaChave('#txtSituacao'),
        CLASSE: pegaChave('#txtClasseGer'),
        BANCO: pegaChave('#txtBanco'),
        NRCAIXA: pegaChave('#txtCaixa'),
        MOEDA: pegaChave('#txtMoeda'),
        HISTORICO: pegaChave('#txtHistorico'),
        CONTA_CH: pegaChave('#txtConta'),
        CONTA_CHEQUE: pegaChave('#txtConta'),
        PEDIDO: pegaValor('#txtPedidoAnte'),
        GERACAIXALOJA: false,
        NAO_LANCA_CC: isChecked('#cbNaoLancaCc')
      };

      let response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        throw new Error(jsonStr.RESULT[0].mensagem);
      }
      const lancamento = jsonStr.lancamento;
      const numero = jsonStr.numero;

      const tipo = await buscaValor('MOEDA', 'TIPO', 'CODMOE', pegaChave('#txtMoeda'));

      if (tipo.TIPO == '3') {
        let sCodCli = await retornaOperadora(pegaChave('#txtMoeda'));
        let novoPrazo = new Date();
        let arrayVencimentos;
        if (pegaChave('#txtCondicaoDePagamento') != '') {
          arrayVencimentos = await RetornaVencimentos(pegaChave('#txtCondicaoDePagamento'));
        }
        if (typeof arrayVencimentos == "undefined") {
          arrayVencimentos = [];
          arrayVencimentos.push(formataData(novoPrazo));
        }
        const valorTotal = parseFloat($('#txtValor').val());
        const nr_parcelas = pegaChave('#txtNrParcelas');
        const moeda = await buscaValor('MOEDA', 'BANCO, BAIXA, HISTORICO, CODSIT', 'CODMOE', pegaChave('#txtMoeda'));
        const conta = await retornaConta(pegaChave('#txtMoeda'));

        let valorParcela = parseFloat(parseFloat(valorTotal / nr_parcelas).toFixed(2));
        let guardaValor = valorParcela;
        let diferenca = 0;
        if (valorTotal > valorParcela * nr_parcelas || valorTotal < valorParcela * nr_parcelas) {
          diferenca = parseFloat(parseFloat(valorTotal - valorParcela * nr_parcelas).toFixed(2));
        }

        for (let i = 0; i < nr_parcelas; i++) {
          if (diferenca > 0 && i == 0) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
            diferenca = 0;
          } else {
            valorParcela = guardaValor;
          }
          if (diferenca < 0 && i == nr_parcelas - 1) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
          }
          const receberClass = {
            VALOR: valorParcela,
            VALOR2: valorParcela,
            DT_EMISSAO: formataData(novoPrazo),
            DT_VENCTO: arrayVencimentos[i],
            STATUS: 'DUPL',
            OBS: `Duplicata gerada pela antecipação ${numero} paga com cartão`,
            CODREP: pegaChave('#txtRepresenAnte'),
            CODCLI: sCodCli,
            SITUACAO: pegaChave('#txtSituacao'),
            CLASSE: pegaChave('#txtClasseGer'),
            BANCO: moeda.BANCO,
            NRCAIXA: pegaChave('#txtCaixa'),
            MOEDA: pegaChave('#txtMoeda'),
            CONTA_CH: conta,
            CARTAO_NSU: $('#txtNSU').val(),
            BANDEIRA: $('#select_bandeira').val(),
            LANCAMENTO: lancamento,
            PARCELA: i + 1,
            TAXACARTAO: true,
            CONDICAO: pegaChave('#txtCondicaoDePagamento'),
            QTDEPARCELAS: pegaChave('#txtNrParcelas'),
            HISTORICO: moeda.HISTORICO,
            SITUACAO: moeda.CODSIT
          };

          response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();

          if (response.status != 200) {
            throw new Error(jsonStr.RESULT[0].mensagem);
          }

          const numeroB = jsonStr.numero;
          const taxaBandeira = jsonStr.taxa_bandeira;

          if (moeda.BAIXA == '1') {
            const receberBClass = await pegaValoresBaixa(numeroB, taxaBandeira, valorParcela, sCodCli);

            response = await requisicao('POST', '/Sisplan/receber/V1/BaixaReceber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberBClass[0]))}`);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status != 200) {
              throw new Error(jsonStr.RESULT[0].mensagem);
            }
          }
        }
      }

      criaMensagemSucesso('Antecipação gravada com sucesso.', async () => {
        await fechaModalAnte();
      });
    } catch (error) {
      msgErro(error.message);
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaOperadora(moeda) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    let retorno = pegaChave('#txtClienteAnte');
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"MOEDA", "camposSelect":[ "USA_ADM_CARTAO", "CODCLI"], "where": ["CODMOE = ${moeda}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.RESULT[0].mensagem);
      }
      if ((jsonStr.RESULT[0][0].CODCLI != '') && (jsonStr.RESULT[0][0].USA_ADM_CARTAO = 'S')) {
        retorno = jsonStr.RESULT[0][0]?.CODCLI;
      }
      return retorno;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da Operadora.");
    }
  }

  async function RetornaVencimentos(iCodCondicao) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let arrVencimentos = [];
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.RESULT[0].mensagem);
      }

      let nrParcelas = jsonStr.RESULT[0].length;
      let dataAtual = new Date();
      for (let index = 0; index < nrParcelas; index++) {
        let novoPrazo = new Date();
        let nrDia = jsonStr.RESULT[0][index].PRAZO;
        novoPrazo.setDate(dataAtual.getDate() + nrDia);
        arrVencimentos.push(formataData(novoPrazo));
      }
      if (typeof arrVencimentos == "undefined") {
        let novoPrazo = new Date();
        arrVencimentos.push(formataData(novoPrazo));
      }

      return arrVencimentos;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function retornaConta(moeda) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"MOEDA_CONTA", "camposSelect":[ "CONTA"], "where": ["MOEDA = ${moeda} AND EMPRESA = '${getCookie('empresa').substring(1, 4)}'"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.RESULT[0].mensagem);
      }

      return jsonStr.RESULT[0][0]?.CONTA;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da Conta.");
    }
  }

  async function pegaValoresBaixa(numeroB, taxaBandeira, valorParcela, sCodCli) {
    try {
      let valores = [];
      let objeto = {};

      objeto = {
        VALOR_PAGO: valorParcela - parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
        DESCONTO: 0,
        JUROS: 0,
        CODCLI: sCodCli,
        CODREP: pegaChave('#txtRepresenAnte'),
        DT_EMISSAO: new Date().toISOString().slice(0, 10),
        DT_VENCTO: new Date().toISOString().slice(0, 10),
        EMP_ID: getCookie('emp_id'),
        DESP_COBRANCA: parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
        NUMERO: numeroB,
        VALOR: valorParcela,
        VALOR2: valorParcela,
        DT_PAGTO: new Date().toISOString().slice(0, 10),
        DT_CONT: new Date().toISOString().slice(0, 10),
        MOEDA: pegaChave("#txtMoeda"),
        NSU: $("#txtNSU").val(),
        BANDEIRA: $('#select_bandeira').val()
      };

      valores.push(objeto);
      objeto = {};

      return valores;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os dados da baixa");
    }
  }

  function limpaCamposAnte() {
    $('#txtClienteAnte').val('')
    $('#txtPedidoAnte').val('')
    $('#txtMoeda').val('')
    $('#txtClasseGer').val('')
    $('#txtSituacao').val('')
    $('#txtHistorico').val('')
    $('#txtRepresentanteAnte').val('')
    $('#txtConta').val('')
    $('#txtBanco').val('')
    $('#txtCaixa').val('')
    $('#txtDTvencimento').val('')
    $('#txtDTemissao').val('')
    $('#txtOrcamentoAnte').val('')
    $('#txtValor').val(0)
  }

  $('#modalAntecipacao').on('hidden.bs.modal', function () {
    limpaCamposAnte()
  })

  async function alteraStatusOs(numOs, numPed) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('POST', '/sisplan/orcamento/v1/alterastatusorcamento?', `&NUMERO=${numOs}&PEDIDO=${numPed}`, null, 36000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.text();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function imprimirPedido(numero) {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/acesso_pedido?`;

        const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
        let arquivo = await GeraRelatorio(`${url}&NUMERO='${numero}'${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function VinculaCaixaComUsuario() {
    const _url = '/sisplan/funcoes/v1/pesquisa?';
    const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
    const _usuarioCaixa =
      `JSON={"tabela": "VENDA_CAIXA", 
      "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO", "VENDA_CAIXA.DEPOSITO", "DEPOSITO.DESCRICAO AS DESC_DEPOSITO", "VENDA_CAIXA.REGIAO", "REGIAO.DESCRICAO AS DESC_REGIAO"], 
      "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'"],
      "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}],
      "leftjoin": [{"tabela" : "DEPOSITO", "condicao" : "DEPOSITO.CODIGO = VENDA_CAIXA.DEPOSITO"},
                   {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = VENDA_CAIXA.REGIAO"}]}`;
    try {
      const response = await requisicao('GET', _url, _usuarioCaixa, null);
      if (!response) {
        msgErro('Erro ao buscar caixas vinculados ao usuário.');
        return;
      }

      if (response.status == 200) {
        var jsonStr = await response.json();
        if (jsonStr['RESULT'][0].length >= 1) {

          if (paramVen54 == '2') { //consultar apenas os caixas vinculados ao usuário
            $('#btn-caixa').pesquisa(
              '#txtCaixa',
              'CODIGO',
              'DESCRICAO',
              `/sisplan/funcoes/v1/pesquisa?JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
                "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
                "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
              }`,
              'Pesquisa Caixa',
              'caixa_loja'
            );

            $('#txtCaixa').autocompleta(
              2,
              `JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
                "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
                "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
              }`
            );
          } else if (paramVen54 == '0') {
            insereValor('#txtCaixa', jsonStr['RESULT'][0][0].NRCAIXA, jsonStr['RESULT'][0][0].DESCRICAO);
            $('#txtCaixa').prop('disabled', true);
            $('#btn-caixa').prop('disabled', true);
            $('#btn-limpa-caixa2').prop('disabled', true);
          }

        }
      } else {
        return;
      }
    } catch (error) {
      console.error(error);
      return;
    }
  }

  $('#btnDesistirAnte, #btnCloseAnte').on('click', async function () {
    await fechaModalAnte(true)
  })

  async function fechaModalAnte(desistir = false) {
    const pedido = pegaValor('#txtPedidoAnte')
    const orcamento = pegaValor('#txtOrcamentoAnte')

    if (desistir) {
      await msgAguardaConfirmacao(`Antecipação não foi gerada. Deseja realmente desistir?`, () => {
        $('#modalAntecipacao').modal('hide');

        callBackImprimir(orcamento, pedido)
      }, () => { })
    } else {
      $('#modalAntecipacao').modal('hide');
      callBackImprimir(orcamento, pedido)
    }
  }

  function addPesquisaAntecipacao() {
    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Moeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btn-limpa-Moeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-Historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-ClasseGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-ClasseGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-Situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-Banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-Banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtConta").autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}', "Pesquisa Conta", "cadconta");
    $("#btn-limpa-Conta").on("click", function () { $("#txtConta").val(""); });

    if (paramVen54 != '2') {
      $('#btn-caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
      $('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
    }
    $("#btn-limpa-caixa2").on("click", function () { $("#txtCaixa").val(""); });
  }

  async function carregaValoresPadroesAnte() {
    const jsonStr = await buscaValoresPadroes('GERAR_ANTECIPACAO')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'MOEDA': {
          if (item.VALOR != '' && $('#txtMoeda').val() == '') {
            insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
            $('#txtMoeda').trigger('blur');
          }
          break;
        }
        case 'HISTORICO': {
          if (item.VALOR != '' && $('#txtHistorico').val() == '') {
            insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CLASSE': {
          if (item.VALOR != '' && $('#txtClasseGer').val() == '') {
            insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'SITUACAO': {
          if (item.VALOR != '' && $('#txtSituacao').val() == '') {
            insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CONTA': {
          if (item.VALOR != '' && $('#txtConta').val() == '') {
            insereValor('#txtConta', item.VALOR, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: item.VALOR });
            $('#txtConta').trigger('blur');
          }
          break;
        }
        case 'BANCO': {
          if (item.VALOR != '' && $('#txtBanco').val() == '') {
            insereValor('#txtBanco', item.VALOR, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: item.VALOR });
          }
          break;
        }

        default:
          break;
      }
    });
  }

  async function adicionaPesquisaFiltros() {
    componenteFiltro("cliente", true);
    componenteFiltro("produto", true);
    componenteFiltro("grupoPA", true);
    componenteFiltro("etiqueta", true);
    componenteFiltro("linha", true);
    componenteFiltro("representante", true, false, 'Representante', objetoFiltroRepresentante.filtrar ? `["REPRESEN.CODREP = '${objetoFiltroRepresentante.codigoRepresentante}'"]` : 'null');

    $('#txtNumero').pesquisa_variosServerside(3, `{ 
      "tabela":"OS", 
      "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], 
      "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}]}`,
      'NUMERO', 'NOME');

    $('#btnNumero').pesquisa_serversideSel('#txtNumero', `{ 
      "tabela":"OS", 
      "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], 
      "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}], 
      "where": null}`, 'Pesquisa Número');

    $('#btnLimpaNumero').on('click', function () {
      $('#txtNumero').empty().trigger('change');
    });

    const repUsuario = await retornaRepUsuario();
    if (repUsuario != '') {
      $('#divRepresentante').addClass('d-none')
    } else {
      $('#divRepresentante').removeClass('d-none')
    }

    const mes = new Date().getMonth() + 1
    const ano = new Date().getFullYear()
    const mesformatado = ZeroE(2, mes.toString())

    $('#txtDtCadastroI').val(`${ano}-${mesformatado}-01`)
    $('#txtDtCadastroF').val('2500-12-01')
  }
});
