$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoTipo',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma cotação de frete.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaCotacao',
                popover: {
                    title: 'Tabela Cotações',
                    description: 'Aqui estão os dados das cotações de frete cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("ORCAMENTOSIMPLES");
    let consultando = true
    await preencheOrdenacaoTela('OrcamentoSimples')
    await preencheOrdenacaoTela('OrcamentoSimplesIndividual', 'txtOrdemIndividual', 'ordemRelatorioIndividual')

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.orcamentosimples == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, orcamentosimples: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, orcamentosimples: novasColunas }))
            $('#tabelaOrcamento').DataTable().columns().visible(true);
            $('#tabelaOrcamento').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

            $('#modal-ColunasVisiveis').modal('hide');
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaOrcamento').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });
        adicionaColunas(cols, colunasInvisiveis.orcamentosimples ?? [], ['NUMERO'])

    })

    await adicionaPesquisaFiltros()
    await buscaDadosOs()

    $("#btnFiltros").on("click", async function () {
        $("#modal-filtros").modal("show");
    });

    $('#btnConsultar').on('click', async function () {
        await buscaDadosOs()
        $("#modal-filtros").modal("hide");
    })

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $('#btnLimparFiltros').on('click', async function () {
        limparFiltros()
    })

    function limparFiltros() {
        $('#txtDtCadastroI').val('1200-01-01')
        $('#txtDtCadastroF').val('2500-12-01')
        $('#txtDtSaidaI').val('1200-01-01')
        $('#txtDtSaidaF').val('2500-12-01')
        $('#txtDtEntregaI').val('1200-01-01')
        $('#txtDtEntregaF').val('2500-12-01')
        $('#txtDtDigitacaoI').val('1200-01-01')
        $('#txtDtDigitacaoF').val('2500-12-01')
        $('#rgTodos').prop('checked', true)
        $('#rgItensTodos').prop('checked', true)
        $('#txtNumero').empty().trigger('change')
        $('#txtCliente').empty().trigger('change')
        $('#txtProduto').empty().trigger('change')
        $('#txtGrupoPA').empty().trigger('change')
        $('#txtEtiqueta').empty().trigger('change')
        $('#txtLinha').empty().trigger('change')
    }

    async function retornaRepUsuario() {
        const filtraClientesRepresentante = await CopiaParametro('SISTEMA', 2) == 1;

        if (!filtraClientesRepresentante) {
            return '';
        }


        const usuarioMasterSupervisor = await uMasterOuSupervisor()

        if (usuarioMasterSupervisor) {
            return ''
        }

        const repUsuario = retornaRepresentanteUsuario()

        return `'${repUsuario}'`
    }

    async function retornaFiltros() {
        const representanteUsuario = await retornaRepUsuario()
        const situacao = $('#rgAberto').is(':checked') ? 1 : $('#rgFechado').is(':checked') ? 2 : $('#rgEmAprovacao').is(':checked') ? 3 : $('#rgPerdido').is(':checked') ? 4 : 0
        const situacaoItem = $('#rgItensAprovado').is(':checked') ? 1 : $('#rgItensReprovado').is(':checked') ? 2 : $('#rgItensBloquetado').is(':checked') ? 3 : 0
        const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')]
        const filtros = `DTCADASTRODE=${$('#txtDtCadastroI').val()}` +
            `&DTCADASTROATE=${$('#txtDtCadastroF').val()}` +
            `&DTSAIDADE=${$('#txtDtSaidaI').val()}` +
            `&DTSAIDAATE=${$('#txtDtSaidaF').val()}` +
            `&DTENTREGADE=${$('#txtDtEntregaI').val()}` +
            `&DTENTREGAATE=${$('#txtDtEntregaF').val()}` +
            `&DTDIGITACAODE=${$('#txtDtDigitacaoI').val()}` +
            `&DTDIGITACAOATE=${$('#txtDtDigitacaoF').val()}` +
            `&SITUACAO=${situacao}` +
            `&SITUACAOITEM=${situacaoItem}` +
            `&NUMEROS=${await formataListas($('#txtNumero').val().toString())}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
            `&MATERIAL=${await formataListas($('#txtMaterial').val().toString())}` +
            `&EMPRESAS=${await formataListas(empresas.toString())}` +
            `&VENDEDOR=${await formataListas($('#txtVendedor').val().toString())}` +
            `&REPUSUARIO=${representanteUsuario}` +
            `&ORCAMENTOSIMPLES=S`;

        return filtros
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelOrcamentoSimplesIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>` +
            `    <button id="btnGerarPedido" type="button" class="dropdown-item">Gerar Pedido</button>` +
            '</div>';
        return retorno;
    };

    async function buscaDadosOs() {
        $.LoadingOverlay('show')
        consultando = true
        try {
            const url = "/sisplan/orcamento/v1/pesquisaacessosimples?"
            const filtros = await retornaFiltros()
            const response = await requisicao('GET', url, filtros, null, 180000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                throw msgAlerta(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                throw msgAlerta('Nenhum registro encontrado!');
            }

            await montaDataTableAcesso(jsonStr)

        } catch (error) {
            $('#modal-filtros').modal('hide')
        } finally {
            $.LoadingOverlay('hide')
            consultando = false
        }
    }

    async function montaDataTableAcesso(jsonStr) {
        if ($.fn.DataTable.isDataTable('#tabelaOrcamento')) {
            $('#tabelaOrcamento').DataTable().destroy();
            $('#tabelaOrcamento').empty();
        }
        let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
        ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

        const dataSetCols = [];
        let keys
        if (ordemColunasRelatorio != null && ordemColunasRelatorio.orcamentosimples != undefined) {
            const ordenacao = 'GERAL'
            const colunas = ordemColunasRelatorio.orcamentosimples.filter(f => f.ordenacao == ordenacao)
            keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(jsonStr[0]);
        } else {
            keys = Object.keys(jsonStr[0]);
        }

        const colunasOriginais = Object.keys(jsonStr[0])

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaOrcamento').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: true,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [keys.indexOf(colunasOriginais[6]), keys.indexOf(colunasOriginais[7]), keys.indexOf(colunasOriginais[8]), keys.indexOf(colunasOriginais[9]), keys.indexOf(colunasOriginais[10])]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [keys.indexOf(colunasOriginais[16]), keys.indexOf(colunasOriginais[17]), keys.indexOf(colunasOriginais[18]), keys.indexOf(colunasOriginais[19]), keys.indexOf(colunasOriginais[20])],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    },
                },
                {
                    targets: [keys.indexOf(colunasOriginais[11])],
                    render(data) {
                        if (data) {
                            switch (data) {
                                case 'A':
                                    return 'Aberto'
                                    break;
                                case 'F':
                                    return 'Fechado'
                                    break;
                                case 'E':
                                    return 'Em Aprovação'
                                    break;
                                case 'P':
                                    return 'Perdido'
                                    break
                                default:
                                    return 'Outro'
                                    break;
                            }
                        } else {
                            return 'Outro'
                        }
                    }
                }
            ]
        });

        $('#tabelaOrcamento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaOrcamento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show')
            try {

                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaOrcamento').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.orcamento).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })

        $('#buttonExcel').off()
        $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaOrcamento").DataTable().data().toArray();
            await exportaCSV('', null, false, null, 'Relatório de Orçamento', '#tabelaOrcamento', '', 999, false, false, dados)
        })

        $('#tabelaOrcamento').on('column-reorder.dt', function (e, settings, details) {
            if (consultando) {
                return
            }
            let newColumnOrder = []

            for (let i = 0; i < settings.aoColumns.length; i++) {
                const column = settings.aoColumns[i].mData

                newColumnOrder.push(column)
            }

            newColumnOrder = newColumnOrder.filter(item => item != 'NUMERO')
            newColumnOrder.unshift('NUMERO')

            let ordemColunas = localStorage.getItem('ordemColunasDataTable')
            ordemColunas = JSON.parse(ordemColunas)
            const ordenacao = 'GERAL'

            if (ordemColunas == null || ordemColunas.orcamentosimples == undefined) {
                localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, orcamentosimples: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

            } else if (!ordemColunas.orcamentosimples.some(s => s.ordenacao == ordenacao)) {

                const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
                ordensSalvas.orcamentosimples.push(newObj)
                localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

            } else if (ordemColunas.orcamentosimples.some(s => s.ordenacao == ordenacao)) {

                const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                ordensSalvas.orcamentosimples.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
                localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
            }
        });

    }

    retornaHintRelatorio('btnImprimir', 'RelOrcamentoSimples')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/orcamento/v1/imprimiracessosimples?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('OrcamentoSimples');
                const ordem = `&TELA_ORDENACAO=OrcamentoSimples&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'OrcamentoSimples');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#tabelaOrcamento").on("click", "#btn-imprimirIndividual", async function () {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();
            const url = `/sisplan/impressao/v1/imprimeorcamentoindividual?`;

            const filtros = `NUMERO=${data.NUMERO}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrcamentoSimplesIndividual');
            const ordem = `&TELA_ORDENACAO=OrcamentoSimplesIndividual&ORDEM_ORDENACAO=${$('#txtOrdemIndividual').val()}`;
            let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 150000, false, 'RelOrcamentoSimplesIndividual');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#btnNovoOrcamento').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "orcamentosimples/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $("#tabelaOrcamento").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $("#tabelaOrcamento")
                .DataTable()
                .row($(this).parents("tr"))
                .data();

            if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
                msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível alterar!')
                return
            }
            if (data.SITUACAO == 'F') {
                msgAlertaSemConfirmacao('Orçamento fechado. Impossível alterar!')
                return
            }
            const orcamentoLiberado = await verificarRegistro("ORCAMENTOSIMPLES", data.NUMERO);
            if (orcamentoLiberado) {
                window.location.href = `orcamentosimples/${data.NUMERO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $("#tabelaOrcamento").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $("#tabelaOrcamento").DataTable().row($(this)).data();

            if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
                msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível alterar!')
                return
            }
            if (data.SITUACAO == 'F') {
                msgAlertaSemConfirmacao('Orçamento fechado. Impossível alterar!')
                return
            }
            const orcamentoLiberado = await verificarRegistro("ORCAMENTOSIMPLES", data.NUMERO);
            if (orcamentoLiberado) {
                window.location.href = `orcamentosimples/${data.NUMERO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $("#tabelaOrcamento").on("click", "#btnGerarPedido", async function () {
        $.LoadingOverlay("show");
        try {
            const permissaoUsuarioLogadoPedido = await permissaoAcessos("PEDIDO");
            if (permissaoUsuarioLogadoPedido.INCLUI == "S") {
                msgAlerta('Deseja criar um Pedido a partir da Proposta Comercial?', async () => {
                    const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr")).data();
                    if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
                        msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível gerar pedido!')
                        return
                    }
                    await gerarPedido(data);
                });
            } else {
                msgAlertaSemConfirmacao("Sem permissão para incluir pedidos!");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $('#tabelaOrcamento').on('click', '#btnExcluir', async function () {
        $.LoadingOverlay("show");
        try {
            if (permissaoUsuarioLogado.EXCLUI == "S") {
                msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                    const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr"));
                    await deletaOs(data);
                });
            } else {
                msgAlertaSemConfirmacao("Sem permissão para excluir!");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function validacaoModifica(numero, exclusao = false) {
        const pesquisa = {
            camposSelect: ["RECEBER.NUMERO REC, OS.SITUACAO"],
            tabela: "OS",
            leftjoin: [{ tabela: "RECEBER", condicao: "RECEBER.CARTAO_PRESENTE = OS.NUMERO" }],
            where: [`OS.NUMERO = '${numero}'`],
            limit: 1
        };

        const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));


        if (exclusao && jsonStr[0].REC != '' && jsonStr[0].REC != null) {
            throw new Error(`Existe Antecipação gerada com número ${jsonStr[0].REC} Impossível continuar.`)
        }

        if (jsonStr[0].SITUACAO == 'F') {
            throw new Error(`Situação do orçamento já fechada, impossível continuar.`)
        }

        if (await Existe('PEDIDO', ['ORCAMENTO'], [numero])) {
            throw new Error('Orçamento já virou pedido, necessário excluir o pedido primeiro.');
        }
    }

    async function deletaOs(data) {
        $.LoadingOverlay('show')
        try {
            let numero = data.data().NUMERO;

            await validacaoModifica(numero, true)

            let response = await requisicao("DELETE", "/sisplan/os/v1/ordemservico?", `NUMERO=${numero}`, null, 50000);
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            }

            toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    data.remove().draw(false);
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function retornaItens(numOs) {
        $.LoadingOverlay('show')
        try {
            const pesquisaParam = {
                tabela: "OS_ITEN",
                camposSelect: [
                    "CODIGO", "TIPO", "COR", "TAM", "QTDE", "PRECO",
                    "ORDEM_DIG", "OBSERVACAO", "NUMERO", "ACRESCIMO",
                    "DESCONTO"
                ],
                where: [`NUMERO = '${numOs}'`]
            };

            const jsonStrItens = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

            let arrItens = [];
            for (let i = 0; i < jsonStrItens.length; i++) {
                const item = jsonStrItens[i]

                arrItens.push({
                    CODIGO: item.CODIGO,
                    COR: item.COR,
                    TAM: item.TAM,
                    QTDE: item.QTDE,
                    QTDE_ORIG: item.QTDE,
                    PRECO: item.PRECO,
                    PRECO_ORIG: item.PRECO,
                    TIPO: item.TIPO,
                    QUALIDADE: '1',
                    ORDEM: item.ORDEM_DIG,
                    OBSERVACAO: item.OBSERVACAO,
                    ACRESCIMO: item.ACRESCIMO,
                    DESCONTO: item.DESCONTO
                })
            }

            return arrItens;

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    };

    async function gerarPedido(data) {
        $.LoadingOverlay('show')
        try {
            if (await Existe('PEDIDO', ['ORCAMENTO'], [data.NUMERO])) {
                throw new Error('Orçamento já virou pedido, impossível continuar.');
            }

            const parametrosComercial = await BuscaParametrosPedido();

            const sNumero = await RetornaProximo('NUMERO', 'PEDIDO', 'NUMERO', 5)

            const pesquisaParam = {
                tabela: "OS",
                camposSelect: [
                    "CLIENTE", "COD_VEN", "CIF", "COM1", "COM2", "TAB_TRANS", "EMP_FAT", "TAB_PRE",
                    "DT_SAIDA", "DT_ENTREGA", "BLOQ_COM", "MOEDA", "SIT_DUP", "CLASSE_GER",
                    "HISTORICO", "STATUS", "FRETE", "PAGTO", "DESCONTO", "OBSERVACAO", "DEPOSITO"
                ],
                where: [`NUMERO = '${data.NUMERO}'`]
            };

            const jsonStrPed = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

            let tabPre = jsonStrPed[0].TAB_PRE

            if (!tabPre) {
                tabPre = '999'
            }

            const arrItens = await retornaItens(data.NUMERO)

            const dadosOs = jsonStrPed[0]
            const pedido = {
                NUMERO: sNumero,
                CODCLI: dadosOs.CLIENTE,
                CODREP: dadosOs.COD_VEN,
                CIF: dadosOs.CIF,
                COM1: dadosOs.COM1,
                COM2: dadosOs.COM2,
                DTDIGITA: retornaDataAtual(),
                DT_EMISSAO: retornaDataAtual(),
                TAB_TRANS: dadosOs.TAB_TRANS,
                FATURA: 100,
                EMP_FAT: dadosOs.EMP_FAT,
                DT_SAIDA: dadosOs.DT_SAIDA,
                DT_FATURA: dadosOs.DT_SAIDA,
                ENTREGA: dadosOs.DT_ENTREGA,
                IND_QTDE: 100,
                TAB_PRE2: '00',
                BLOQUEIO: dadosOs.BLOQ_COM,
                FINANCEIRO: parametrosComercial[2].VALOR,
                PERIODO: '0',
                MOEDA: dadosOs.MOEDA,
                SIT_DUP: dadosOs.SIT_DUP,
                CLASSE_GER: dadosOs.CLASSE_GER,
                HISTORICO: dadosOs.HISTORICO,
                STATUS: dadosOs.STATUS,
                STATUS_PED: dadosOs.STATUS,
                ID_TIPO: 0,
                FRETE: dadosOs.FRETE,
                PGTO: dadosOs.PAGTO,
                PER_DESC: dadosOs.DESCONTO,
                ORCAMENTO: data.NUMERO,
                BONIFICACAO: 'N',
                OBS: dadosOs.OBSERVACAO,
                REC_SIMULA: [],
                EMP_ID: getCookie('emp_id'),
                DEPOSITO: dadosOs.DEPOSITO,
                TAB_PRE: tabPre,
                ITENS: arrItens
            };

            const response = await requisicao('POST', '/sisplan/pedido/v1/pedido?', `&BARRAS_LOG=${encodeURIComponent(JSON.stringify({ BARRAS: [] }))}`, encodeURIComponent(JSON.stringify(pedido)), 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay('hide');
                msgErro(jsonStr.mensagem);
                return;
            }

            $.LoadingOverlay('hide');

            msgAlerta('Deseja imprimir o pedido?',
                async () => { await imprimirPedido(sNumero); callBack(); },
                () => { callBack(sNumero); },
                () => { },
                () => { callBack(sNumero); });

            function callBack() {
                criaMensagemSucesso(`Pedido ${sNumero} gravado com sucesso!`, async () => {
                    await alteraStatusOs(data.NUMERO, sNumero)
                });
            }

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }


    async function imprimirPedido(numero) {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/acesso_pedido?`;

                const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=1`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
                let arquivo = await GeraRelatorio(`${url}&NUMERO='${numero}'${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function alteraStatusOs(numOs, numPed) {
        $.LoadingOverlay('show')
        try {
            const response = await requisicao('POST', '/sisplan/orcamento/v1/alterastatusorcamento?', `&NUMERO=${numOs}&PEDIDO=${numPed}`, null, 36000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            const jsonStr = await response.text();
            if (response.status != 200) {
                $.LoadingOverlay('hide');
                msgErro(jsonStr.mensagem);
                return;
            }

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function adicionaPesquisaFiltros() {
        componenteFiltro("cliente", true);
        componenteFiltro("produto", true);
        componenteFiltro("material", true);
        componenteFiltro("representante", true, true, 'Vendedor');

        $('#txtNumero').pesquisa_variosServerside(3, `{ 
          "tabela":"OS", 
          "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], 
          "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}]}`,
            'NUMERO', 'NOME');

        $('#btnNumero').pesquisa_serversideSel('#txtNumero', `{ 
          "tabela":"OS", 
          "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], 
          "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}], 
          "where": null}`, 'Pesquisa Número');

        $('#btnLimpaNumero').on('click', function () {
            $('#txtNumero').empty().trigger('change');
        });

        const usuarioMasterSupervisor = await uMasterOuSupervisor()

        if (usuarioMasterSupervisor) {
            $('#divVendedor').removeClass('d-none')
        } else {
            $('#divVendedor').addClass('d-none')
        }

        const mes = new Date().getMonth() + 1
        const ano = new Date().getFullYear()
        const mesformatado = ZeroE(2, mes.toString())

        $('#txtDtCadastroI').val(`${ano}-${mesformatado}-01`)
        $('#txtDtCadastroF').val('2500-12-01')
    }
});