<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Cliente de Tingimento</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.11.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.11.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.11.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.11.1">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-10 flex">
              <h1 class="m-0 text-dark">Relatório de Cliente de Tingimento</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-2">
 
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="card-body">
                  <div class="card">
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaRelCliente" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                      <thead>
                        <tr></tr>
                      </thead>
                      <tbody>
                        <tr></tr>
                      </tbody>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body py-1 px-0">
            <div class="card-body pt-0 pb-0">
              <div class="row">
                <div class="col-12">
                  <div class="row mt-2">
                    <div class="col-xl-2 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="dtCadastroDe">Cadastro De: </label>
                      <div class="relative">
                        <div class="input-group px-0 col-12">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtCadastroDe" name="dtCadastroDe" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="dtCadastroDe">Até: </label>
                      <div class="relative">
                        <div class="input-group px-0 col-12">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtCadastroAte" name="dtCadastroAte" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group d-none">
                      <label data-error="wrong" data-success="right">Sem compras loja De: </label>
                      <div class="relative">
                        <div class="input-group px-0 col-12">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtSemComprasLojaDe" name="dtSemComprasLojaDe" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group d-none">
                      <label data-error="wrong" data-success="right">Até: </label>
                      <div class="relative">
                        <div class="input-group px-0 col-12">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtSemComprasLojaAte" name="dtSemComprasLojaAte" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group d-none">
                      <label data-error="wrong" data-success="right" for="dtSemComprasDesde">Sem compras desde: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtSemComprasDesde" name="dtSemComprasDesde" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group d-none">
                      <label data-error="wrong" data-success="right" for="dtComComprasAPartir">Com compras a partir de: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtComComprasAPartir" name="dtComComprasAPartir" class="form-control">
                        </div>
                      </div>
                    </div>

                    <div class="col-xl-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-cliente-filtro" name="btn-cliente-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtGrupo">Grupo de cliente:</label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtGrupo" name="txtGrupo" class="form-control" placeholder="Grupo de cliente:">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-grupo-filtro" name="btn-grupo-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-grupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtGrupo">Representante:</label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" disabled class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" class="form-control" placeholder="Representante:">
                          <div class="input-group-append d-none">
                            <button class="btn bg-danger" id="btn-representante-filtro" name="btn-grupo-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-xl-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtPais">País: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtPais" name="txtPais" class="form-control" placeholder="País">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-pais-filtro" name="btn-pais" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-pais" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCidade">Cidade: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCidade" name="txtCidade" class="form-control" placeholder="Cidade">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-cidade-filtro" name="btn-cidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-cidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-xl-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtUf">UF: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtUf" name="txtUf" class="form-control" placeholder="UF">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-UfConsulta" name="btn-UfConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-Uf" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-12 form-group d-none">
                      <label data-error="wrong" data-success="right" for="txtEmpresa">Empresa Cadastro: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtEmpresa" name="txtEmpresa" class="form-control" placeholder="Empresa">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-EmpresaConsulta" name="btn-EmpresaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-Empresa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>

                    <!-- <div class="row divSelect col-xl-8 col-12"> -->
                    <div class="col-xl-2 col-12 form-group">
                      <div class="form-group">
                        <label>Tipo: </label>
                        <select class="form-control select2 select2-danger" id="cli_tipo" name="cli_tipo" data-dropdown-css-class="select2-danger" style="width: 100%;">
                          <option selected="selected" value="0">Todos</option>
                          <option value="1">Física</option>
                          <option value="2">Jurídica</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group">
                      <div class="form-group">
                        <label>Ativo: </label>
                        <select class="form-control select2 select2-danger" id="cli_ativo" name="cli_ativo" data-dropdown-css-class="select2-danger" style="width: 100%;">
                          <option selected="selected" value="0">Todos</option>
                          <option value="1">Ativos</option>
                          <option value="2">Inativos</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group">
                      <div class="form-group">
                        <label>Situação: </label>
                        <select class="form-control select2 select2-danger" id="cli_situacao" name="cli_situacao" data-dropdown-css-class="select2-danger" style="width: 100%;">
                          <option selected="selected" value="0">Todos</option>
                          <option value="1">Liberado</option>
                          <option value="2">Bloqueado</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-2 col-12 form-group mt-4 pt-2">
                      <div class="form-group form-check pl-4 icheck-primary">
                        <input style="transform: scale(1.5)" type="checkbox" class="form-check-input" id="cbCliConsumidorFinal">
                        <label for="cbCliConsumidorFinal">Consumidor Final</label>
                      </div>
                    </div>
                    <!-- </div> -->
                  </div>

                </div>
              </div>
            </div>
          </div>

          <div class="modal-footer justify-content-start pl-0">
            <div class="row col-12">
              <div class="col-xl-4 col-12">
                <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>

          <!-- <div class="col-xl-6 col-12 form-group">
            <label data-error="wrong" class="labelGearal" data-success="right" for="txtOrdem">Ordem Impressão</label>
            <div class="input-group">
              <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtOrdem" class="custom-select">
              </select>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>   
              <button id="btnConsultar" class='btn btn-primary btn-sisp' type='button'><span class="fas fa-search"></span> Consultar </button>
            </div>
          </div> -->
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php include_once('../../modais.php'); ?>
  </main><!-- /.wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.11.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.11.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2511.11.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2511.11.1"></script>
  <script src="utils/funcoes.js?versao=3.2511.11.1"></script>
  <script src="utils/cookies.js?versao=3.2511.11.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2511.11.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2511.11.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.2511.11.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELCLITINGIMENTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relclitingimento/relclitingimento.js?versao=3.2511.11.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>