$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: "#conteudo",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#checkAtivo",
        popover: {
          title: "Ativo",
          description:
            "Aqui definimos como ativo o subgrupo.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para o subgrupo.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let subgrupo = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/subgrupoma`;
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe um código válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $('#txtCodigo').prop('disabled', true);

  if (subgrupo != "" && subgrupo != "create") {

    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"SUBGRUPO_MA", 
                  "camposSelect":["codigo", "descricao", "ativo"], 
                  "where": ["codigo = '${subgrupo}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
        $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);

        if (jsonStr.RESULT[0][0].ATIVO == "S") {
          $("#checkAtivo").prop("checked", true);
        } else {
          $("#checkAtivo").prop("checked", false);
        }

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados do subgrupo: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  } else {
    $("#checkAtivo").prop("checked", true);
  }

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let subgrupoClasse = {};

        subgrupoClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('SUBGRUPO_MA', 'SUBGRUPO_MA', 'CODIGO', 2) : $('#txtCodigo').val();
        subgrupoClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();

        if ($("#checkAtivo").prop("checked")) {
          subgrupoClasse.ATIVO = "S";
        } else {
          subgrupoClasse.ATIVO = "N";
        }

        let response = await requisicao(
          "POST",
          "/sisplan/cadastros/v1/subgrupoma?",
          `JSON=${encodeURIComponent(JSON.stringify(subgrupoClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(`Cadastro efetuado com sucesso! Código: ${subgrupoClasse.CODIGO}`, "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/subgrupoma`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
