$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if (Element.node.id == "gravar") {
          $(".driver-next-btn").on("click", location.reload());
        }
      },
      onPrevious: (Element) => {
        if (Element.node.id == "formcard1") {
          $(".driver-close-btn").on("click", location.reload());
        }
      },
    });

    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#tutorialCodigo",
        popover: {
          title: "Código",
          description:
            "Aqui adicionamos o código para a Classificação Tributária.",
          position: "top",
        },
      },
      {
        element: "#tutorialDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição da Classificação Tributária.",
          position: "top",
        },
      },
      {
        element: "#tutorialPadrao",
        popover: {
          title: "Padrão",
          description:
            "Aqui selecionamos se será a Classificação Padrão, poderá ter apenas uma classificação como padrão.",
          position: "top",
        },
      },
      {
        element: "#tutorialTributacao",
        popover: {
          title: "Tributação ICMS",
          description:
            "Aqui selecionamos qual o tipo de Tributação ICMS da classificação.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let tpPessoa = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("TIPOPESSOA", getCookie("usuario"), tpPessoa);
    window.location.href = `${BASE_URI}/tipopessoa`;
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe um código válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  if (tpPessoa != "" && tpPessoa != "create") {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"TPDOCPESSOA", 
                    "camposSelect":["codigo", "descricao", "ativo", "mascara"], 
                    "where": ["codigo = '${tpPessoa}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
        $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
        $("#txtMascara").val(jsonStr.RESULT[0][0].MASCARA);

        if (jsonStr.RESULT[0][0].ATIVO == "S") {
          $("#checkAtivo").prop("checked", true);
        }

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados do tipo de pessoa: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  } else {
    insereValor('#txtCodigo', await RetornaProximo("TPDOCPESSOA", "TPDOCPESSOA", "CODIGO", 1));
    $("#checkAtivo").prop("checked", true);
  }

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let cTpPessoa = {};

        cTpPessoa.CODIGO = $("#txtCodigo").val();
        cTpPessoa.DESCRICAO = $("#txtDescricao").val();
        cTpPessoa.MASCARA = $("#txtMascara").val();

        if ($("#checkAtivo").prop("checked")) {
          cTpPessoa.ATIVO = "S";
        } else {
          cTpPessoa.ATIVO = "N";
        }

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/tipopessoa?",
          `JSON=${encodeURIComponent(JSON.stringify(cTpPessoa))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/tipopessoa`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
